/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Preconditions;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnValueSelector;
import javax.annotation.Nullable;

public class ConstantColumnValueSelector<T>
implements ColumnValueSelector<T> {
    private long longValue;
    private float floatValue;
    private double doubleValue;
    @Nullable
    private T objectValue;
    private Class<T> objectClass;

    public ConstantColumnValueSelector(long longValue, float floatValue, double doubleValue, @Nullable T objectValue, Class<T> objectClass) {
        this.longValue = longValue;
        this.floatValue = floatValue;
        this.doubleValue = doubleValue;
        this.objectValue = objectValue;
        this.objectClass = (Class)Preconditions.checkNotNull(objectClass, (Object)"objectClass");
    }

    @Override
    public double getDouble() {
        return this.doubleValue;
    }

    @Override
    public float getFloat() {
        return this.floatValue;
    }

    @Override
    public long getLong() {
        return this.longValue;
    }

    @Override
    @Nullable
    public T getObject() {
        return this.objectValue;
    }

    @Override
    public Class<T> classOfObject() {
        return this.objectClass;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

