/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Strings;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.spatial.ImmutableRTree;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.filter.Filters;
import java.util.Iterator;

public class ColumnSelectorBitmapIndexSelector
implements BitmapIndexSelector {
    private final BitmapFactory bitmapFactory;
    private final VirtualColumns virtualColumns;
    private final ColumnSelector index;

    public ColumnSelectorBitmapIndexSelector(BitmapFactory bitmapFactory, VirtualColumns virtualColumns, ColumnSelector index) {
        this.bitmapFactory = bitmapFactory;
        this.virtualColumns = virtualColumns;
        this.index = index;
    }

    @Override
    public Indexed<String> getDimensionValues(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return null;
        }
        Column columnDesc = this.index.getColumn(dimension);
        if (columnDesc == null || !columnDesc.getCapabilities().isDictionaryEncoded()) {
            return null;
        }
        final DictionaryEncodedColumn column = columnDesc.getDictionaryEncoding();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return column.getCardinality();
            }

            @Override
            public String get(int index) {
                return (String)column.lookupName(index);
            }

            @Override
            public int indexOf(String value) {
                return column.lookupId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", column);
            }
        };
    }

    @Override
    public boolean hasMultipleValues(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return this.virtualColumns.getVirtualColumn(dimension).capabilities(dimension).hasMultipleValues();
        }
        Column column = this.index.getColumn(dimension);
        return column != null && column.getCapabilities().hasMultipleValues();
    }

    @Override
    public int getNumRows() {
        try (GenericColumn column = this.index.getColumn("__time").getGenericColumn();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    public BitmapIndex getBitmapIndex(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return null;
        }
        Column column = this.index.getColumn(dimension);
        if (column == null || !ColumnSelectorBitmapIndexSelector.columnSupportsFiltering(column)) {
            return new BitmapIndex(){

                @Override
                public int getCardinality() {
                    return 1;
                }

                @Override
                public String getValue(int index) {
                    return null;
                }

                @Override
                public boolean hasNulls() {
                    return true;
                }

                @Override
                public BitmapFactory getBitmapFactory() {
                    return ColumnSelectorBitmapIndexSelector.this.bitmapFactory;
                }

                @Override
                public int getIndex(String value) {
                    return Strings.isNullOrEmpty((String)value) ? 0 : -2;
                }

                @Override
                public ImmutableBitmap getBitmap(int idx) {
                    if (idx == 0) {
                        return ColumnSelectorBitmapIndexSelector.this.bitmapFactory.complement(ColumnSelectorBitmapIndexSelector.this.bitmapFactory.makeEmptyImmutableBitmap(), ColumnSelectorBitmapIndexSelector.this.getNumRows());
                    }
                    return ColumnSelectorBitmapIndexSelector.this.bitmapFactory.makeEmptyImmutableBitmap();
                }
            };
        }
        if (column.getCapabilities().hasBitmapIndexes()) {
            return column.getBitmapIndex();
        }
        return null;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(String dimension, String value) {
        if (this.isVirtualColumn(dimension)) {
            return null;
        }
        Column column = this.index.getColumn(dimension);
        if (column == null || !ColumnSelectorBitmapIndexSelector.columnSupportsFiltering(column)) {
            if (Strings.isNullOrEmpty((String)value)) {
                return this.bitmapFactory.complement(this.bitmapFactory.makeEmptyImmutableBitmap(), this.getNumRows());
            }
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        if (!column.getCapabilities().hasBitmapIndexes()) {
            return null;
        }
        BitmapIndex bitmapIndex = column.getBitmapIndex();
        return bitmapIndex.getBitmap(bitmapIndex.getIndex(value));
    }

    @Override
    public ImmutableRTree getSpatialIndex(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return ImmutableRTree.empty();
        }
        Column column = this.index.getColumn(dimension);
        if (column == null || !column.getCapabilities().hasSpatialIndexes()) {
            return ImmutableRTree.empty();
        }
        return column.getSpatialIndex().getRTree();
    }

    private boolean isVirtualColumn(String columnName) {
        return this.virtualColumns.getVirtualColumn(columnName) != null;
    }

    private static boolean columnSupportsFiltering(Column column) {
        ValueType columnType = column.getCapabilities().getType();
        return Filters.FILTERABLE_TYPES.contains((Object)columnType);
    }
}

