/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn.types;

import io.druid.java.util.common.IAE;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.query.topn.types.NumericTopNColumnSelectorStrategy;
import io.druid.query.topn.types.StringTopNColumnSelectorStrategy;
import io.druid.query.topn.types.TopNColumnSelectorStrategy;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;

public class TopNColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<TopNColumnSelectorStrategy> {
    @Override
    public TopNColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringTopNColumnSelectorStrategy();
            }
            case LONG: {
                return new NumericTopNColumnSelectorStrategy.OfLong();
            }
            case FLOAT: {
                return new NumericTopNColumnSelectorStrategy.OfFloat();
            }
            case DOUBLE: {
                return new NumericTopNColumnSelectorStrategy.OfDouble();
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
    }
}

