/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import io.druid.query.ColumnSelectorPlus;
import io.druid.query.topn.types.TopNColumnSelectorStrategy;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;

public class TopNParams {
    private final Cursor cursor;
    private final int cardinality;
    private final int numValuesPerPass;
    private final ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus;

    protected TopNParams(ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus, Cursor cursor, int numValuesPerPass) {
        this.selectorPlus = selectorPlus;
        this.cursor = cursor;
        this.cardinality = selectorPlus.getColumnSelectorStrategy().getCardinality(selectorPlus.getSelector());
        this.numValuesPerPass = numValuesPerPass;
    }

    public DimensionSelector getDimSelector() {
        return (DimensionSelector)this.selectorPlus.getSelector();
    }

    public ColumnSelectorPlus<TopNColumnSelectorStrategy> getSelectorPlus() {
        return this.selectorPlus;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getNumValuesPerPass() {
        return this.numValuesPerPass;
    }
}

