/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import io.druid.java.util.common.IAE;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.Result;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryMetrics;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.TopNResultValue;
import io.druid.query.topn.types.TopNColumnSelectorStrategy;
import io.druid.query.topn.types.TopNColumnSelectorStrategyFactory;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.column.ValueType;
import java.util.Objects;
import javax.annotation.Nullable;

public class TopNMapFn {
    private static Function<Object, Object> STRING_TRANSFORMER = input -> Objects.toString(input, null);
    private static Function<Object, Object> LONG_TRANSFORMER = input -> {
        Long longVal = DimensionHandlerUtils.convertObjectToLong(input);
        return longVal == null ? DimensionHandlerUtils.ZERO_LONG : longVal;
    };
    private static Function<Object, Object> FLOAT_TRANSFORMER = input -> {
        Float floatVal = DimensionHandlerUtils.convertObjectToFloat(input);
        return floatVal == null ? DimensionHandlerUtils.ZERO_FLOAT : floatVal;
    };
    private static Function<Object, Object> DOUBLE_TRANSFORMER = input -> {
        Double doubleValue = DimensionHandlerUtils.convertObjectToDouble(input);
        return doubleValue == null ? DimensionHandlerUtils.ZERO_DOUBLE : doubleValue;
    };
    private static final TopNColumnSelectorStrategyFactory STRATEGY_FACTORY = new TopNColumnSelectorStrategyFactory();
    private final TopNQuery query;
    private final TopNAlgorithm topNAlgorithm;

    public static Function<Object, Object> getValueTransformer(ValueType outputType) {
        switch (outputType) {
            case STRING: {
                return STRING_TRANSFORMER;
            }
            case LONG: {
                return LONG_TRANSFORMER;
            }
            case FLOAT: {
                return FLOAT_TRANSFORMER;
            }
            case DOUBLE: {
                return DOUBLE_TRANSFORMER;
            }
        }
        throw new IAE("invalid type: %s", new Object[]{outputType});
    }

    public TopNMapFn(TopNQuery query, TopNAlgorithm topNAlgorithm) {
        this.query = query;
        this.topNAlgorithm = topNAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<TopNResultValue> apply(Cursor cursor, @Nullable TopNQueryMetrics queryMetrics) {
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = DimensionHandlerUtils.createColumnSelectorPlus(STRATEGY_FACTORY, this.query.getDimensionSpec(), cursor.getColumnSelectorFactory());
        if (selectorPlus.getSelector() == null) {
            return null;
        }
        TopNParams params = null;
        try {
            params = this.topNAlgorithm.makeInitParams(selectorPlus, cursor);
            if (queryMetrics != null) {
                queryMetrics.columnValueSelector(selectorPlus.getSelector());
                queryMetrics.numValuesPerPass(params);
            }
            TopNResultBuilder resultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, this.query);
            this.topNAlgorithm.run(params, resultBuilder, null, queryMetrics);
            Result<TopNResultValue> result = resultBuilder.build();
            return result;
        }
        finally {
            this.topNAlgorithm.cleanup(params);
        }
    }
}

