/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import io.druid.query.aggregation.SimpleDoubleBufferAggregator;
import io.druid.query.topn.Historical1AggPooledTopNScanner;
import io.druid.query.topn.TopNUtils;
import io.druid.segment.data.Offset;
import io.druid.segment.historical.HistoricalColumnSelector;
import io.druid.segment.historical.HistoricalCursor;
import io.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import java.nio.ByteBuffer;

public class HistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopNScannerPrototype
implements Historical1AggPooledTopNScanner<SingleValueHistoricalDimensionSelector, HistoricalColumnSelector, SimpleDoubleBufferAggregator> {
    @Override
    public long scanAndAggregate(SingleValueHistoricalDimensionSelector dimensionSelector, HistoricalColumnSelector metricSelector, SimpleDoubleBufferAggregator aggregator, int aggregatorSize, HistoricalCursor cursor, int[] positions, ByteBuffer resultsBuffer) {
        Offset offset = (Offset)TopNUtils.copyOffset(cursor);
        long processedRows = 0L;
        int positionToAllocate = 0;
        while (offset.withinBounds() && !Thread.currentThread().isInterrupted()) {
            int rowNum = offset.getOffset();
            int dimIndex = dimensionSelector.getRowValue(rowNum);
            int position = positions[dimIndex];
            if (position >= 0) {
                aggregator.aggregate(resultsBuffer, position, metricSelector.getDouble(rowNum));
            } else if (position == -1) {
                positions[dimIndex] = positionToAllocate;
                aggregator.putFirst(resultsBuffer, positionToAllocate, metricSelector.getDouble(rowNum));
                positionToAllocate += aggregatorSize;
            }
            ++processedRows;
            offset.increment();
        }
        return processedRows;
    }
}

