/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import io.druid.query.aggregation.SimpleDoubleBufferAggregator;
import io.druid.query.topn.Historical1AggPooledTopNScanner;
import io.druid.query.topn.TopNUtils;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.Offset;
import io.druid.segment.historical.HistoricalColumnSelector;
import io.druid.segment.historical.HistoricalCursor;
import io.druid.segment.historical.HistoricalDimensionSelector;
import java.nio.ByteBuffer;

public class Historical1SimpleDoubleAggPooledTopNScannerPrototype
implements Historical1AggPooledTopNScanner<HistoricalDimensionSelector, HistoricalColumnSelector, SimpleDoubleBufferAggregator> {
    @Override
    public long scanAndAggregate(HistoricalDimensionSelector dimensionSelector, HistoricalColumnSelector metricSelector, SimpleDoubleBufferAggregator aggregator, int aggregatorSize, HistoricalCursor cursor, int[] positions, ByteBuffer resultsBuffer) {
        Offset offset = (Offset)TopNUtils.copyOffset(cursor);
        long processedRows = 0L;
        int positionToAllocate = 0;
        while (offset.withinBounds() && !Thread.currentThread().isInterrupted()) {
            int rowNum = offset.getOffset();
            double metric = metricSelector.getDouble(rowNum);
            IndexedInts dimValues = dimensionSelector.getRow(rowNum);
            int dimSize = dimValues.size();
            for (int i = 0; i < dimSize; ++i) {
                int dimIndex = dimValues.get(i);
                int position = positions[dimIndex];
                if (position >= 0) {
                    aggregator.aggregate(resultsBuffer, position, metric);
                    continue;
                }
                if (position != -1) continue;
                positions[dimIndex] = positionToAllocate;
                aggregator.putFirst(resultsBuffer, positionToAllocate, metric);
                positionToAllocate += aggregatorSize;
            }
            ++processedRows;
            offset.increment();
        }
        return processedRows;
    }
}

