/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.topn.Generic1AggPooledTopNScanner;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.nio.ByteBuffer;

public final class Generic1AggPooledTopNScannerPrototype
implements Generic1AggPooledTopNScanner {
    @Override
    public long scanAndAggregate(DimensionSelector dimensionSelector, BufferAggregator aggregator, int aggregatorSize, Cursor cursor, int[] positions, ByteBuffer resultsBuffer) {
        long processedRows = 0L;
        int positionToAllocate = 0;
        while (!cursor.isDoneOrInterrupted()) {
            IndexedInts dimValues = dimensionSelector.getRow();
            int dimSize = dimValues.size();
            for (int i = 0; i < dimSize; ++i) {
                int dimIndex = dimValues.get(i);
                int position = positions[dimIndex];
                if (position >= 0) {
                    aggregator.aggregate(resultsBuffer, position);
                    continue;
                }
                if (position != -1) continue;
                positions[dimIndex] = positionToAllocate;
                position = positionToAllocate;
                aggregator.init(resultsBuffer, position);
                aggregator.aggregate(resultsBuffer, position);
                positionToAllocate += aggregatorSize;
            }
            ++processedRows;
            cursor.advanceUninterruptibly();
        }
        return processedRows;
    }
}

