/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNMapFn;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.types.TopNColumnSelectorStrategy;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import java.util.Map;

public class DimExtractionTopNAlgorithm
extends BaseTopNAlgorithm<Aggregator[][], Map<Comparable, Aggregator[]>, TopNParams> {
    private final TopNQuery query;

    public DimExtractionTopNAlgorithm(Capabilities capabilities, TopNQuery query) {
        super(capabilities);
        this.query = query;
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus, Cursor cursor) {
        return new TopNParams(selectorPlus, cursor, Integer.MAX_VALUE);
    }

    @Override
    protected Aggregator[][] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = params.getSelectorPlus();
        return selectorPlus.getColumnSelectorStrategy().getDimExtractionRowSelector(this.query, params, this.capabilities);
    }

    @Override
    protected Aggregator[][] updateDimValSelector(Aggregator[][] aggregators, int numProcessed, int numToProcess) {
        return aggregators;
    }

    @Override
    protected Map<Comparable, Aggregator[]> makeDimValAggregateStore(TopNParams params) {
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = params.getSelectorPlus();
        return selectorPlus.getColumnSelectorStrategy().makeDimExtractionAggregateStore();
    }

    @Override
    public long scanAndAggregate(TopNParams params, Aggregator[][] rowSelector, Map<Comparable, Aggregator[]> aggregatesStore) {
        Cursor cursor = params.getCursor();
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = params.getSelectorPlus();
        return selectorPlus.getColumnSelectorStrategy().dimExtractionScanAndAggregate(this.query, selectorPlus.getSelector(), cursor, rowSelector, aggregatesStore);
    }

    @Override
    protected void updateResults(TopNParams params, Aggregator[][] rowSelector, Map<Comparable, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = params.getSelectorPlus();
        boolean needsResultTypeConversion = this.needsResultTypeConversion(params);
        Function<Object, Object> valueTransformer = TopNMapFn.getValueTransformer(this.query.getDimensionSpec().getOutputType());
        selectorPlus.getColumnSelectorStrategy().updateDimExtractionResults(aggregatesStore, (Function<Object, Object>)(needsResultTypeConversion ? valueTransformer : null), resultBuilder);
    }

    @Override
    protected void closeAggregators(Map<Comparable, Aggregator[]> valueMap) {
        for (Aggregator[] aggregators : valueMap.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }

    private boolean needsResultTypeConversion(TopNParams params) {
        ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus = params.getSelectorPlus();
        TopNColumnSelectorStrategy strategy = selectorPlus.getColumnSelectorStrategy();
        return this.query.getDimensionSpec().getOutputType() != strategy.getValueType();
    }
}

