/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Json;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.topn.DefaultTopNQueryMetrics;
import io.druid.query.topn.TopNQueryMetrics;
import io.druid.query.topn.TopNQueryMetricsFactory;

@LazySingleton
public class DefaultTopNQueryMetricsFactory
implements TopNQueryMetricsFactory {
    private static final TopNQueryMetricsFactory INSTANCE = new DefaultTopNQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static TopNQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultTopNQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TopNQueryMetrics makeMetrics() {
        return new DefaultTopNQueryMetrics(this.jsonMapper);
    }
}

