/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.query.DefaultQueryMetrics;
import io.druid.query.DruidMetrics;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryMetrics;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.Cursor;

public class DefaultTopNQueryMetrics
extends DefaultQueryMetrics<TopNQuery>
implements TopNQueryMetrics {
    public DefaultTopNQueryMetrics(ObjectMapper jsonMapper) {
        super(jsonMapper);
    }

    @Override
    public void query(TopNQuery query) {
        super.query(query);
        this.threshold(query);
        this.dimension(query);
        this.numMetrics(query);
        this.numComplexMetrics(query);
        this.granularity(query);
    }

    @Override
    public void threshold(TopNQuery query) {
        this.setDimension("threshold", String.valueOf(query.getThreshold()));
    }

    @Override
    public void dimension(TopNQuery query) {
        this.setDimension("dimension", query.getDimensionSpec().getDimension());
    }

    @Override
    public void numMetrics(TopNQuery query) {
        this.setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size()));
    }

    @Override
    public void numComplexMetrics(TopNQuery query) {
        int numComplexAggs = DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs());
        this.setDimension("numComplexMetrics", String.valueOf(numComplexAggs));
    }

    @Override
    public void granularity(TopNQuery query) {
    }

    @Override
    public void dimensionCardinality(int cardinality) {
    }

    @Override
    public void algorithm(TopNAlgorithm algorithm) {
    }

    @Override
    public void cursor(Cursor cursor) {
    }

    @Override
    public void columnValueSelector(ColumnValueSelector columnValueSelector) {
    }

    @Override
    public void numValuesPerPass(TopNParams params) {
    }

    @Override
    public TopNQueryMetrics addProcessedRows(long numRows) {
        return this;
    }

    @Override
    public void startRecordingScanTime() {
    }

    @Override
    public TopNQueryMetrics stopRecordingScanTime() {
        return this;
    }
}

