/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.java.util.common.StringUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.ordering.StringComparators;
import io.druid.query.topn.LexicographicTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public class AlphaNumericTopNMetricSpec
extends LexicographicTopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 2;
    protected static Comparator<String> comparator = StringComparators.ALPHANUMERIC;

    @JsonCreator
    public AlphaNumericTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        super(previousStop);
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return comparator;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.getPreviousStop() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getPreviousStop());
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)2).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public String toString() {
        return "AlphaNumericTopNMetricSpec{previousStop='" + this.getPreviousStop() + '\'' + '}';
    }
}

