/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class TimeseriesQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private final TimeseriesQueryQueryToolChest toolChest;
    private final TimeseriesQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeseriesQueryRunnerFactory(TimeseriesQueryQueryToolChest toolChest, TimeseriesQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> createRunner(Segment segment) {
        return new TimeseriesQueryRunner(this.engine, segment.asStorageAdapter());
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeseriesResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeseriesResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> getToolchest() {
        return this.toolChest;
    }

    private static class TimeseriesQueryRunner
    implements QueryRunner<Result<TimeseriesResultValue>> {
        private final TimeseriesQueryEngine engine;
        private final StorageAdapter adapter;

        private TimeseriesQueryRunner(TimeseriesQueryEngine engine, StorageAdapter adapter) {
            this.engine = engine;
            this.adapter = adapter;
        }

        @Override
        public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> responseContext) {
            Query<Result<TimeseriesResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeseriesQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TimeseriesQuery.class});
            }
            return this.engine.process((TimeseriesQuery)input, this.adapter);
        }
    }
}

