/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Queries;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.VirtualColumns;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="timeseries")
public class TimeseriesQuery
extends BaseQuery<Result<TimeseriesResultValue>> {
    private final VirtualColumns virtualColumns;
    private final DimFilter dimFilter;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;

    @JsonCreator
    public TimeseriesQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="descending") boolean descending, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, descending, context, granularity);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.dimFilter = dimFilter;
        this.aggregatorSpecs = aggregatorSpecs == null ? ImmutableList.of() : aggregatorSpecs;
        this.postAggregatorSpecs = Queries.prepareAggregations((List<String>)ImmutableList.of(), this.aggregatorSpecs, (List<PostAggregator>)(postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs));
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "timeseries";
    }

    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public boolean isSkipEmptyBuckets() {
        return this.getContextBoolean("skipEmptyBuckets", false);
    }

    public TimeseriesQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return Druids.TimeseriesQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    @Override
    public Query<Result<TimeseriesResultValue>> withDataSource(DataSource dataSource) {
        return Druids.TimeseriesQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public TimeseriesQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = TimeseriesQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.TimeseriesQueryBuilder.copy(this).context(newContext).build();
    }

    public TimeseriesQuery withDimFilter(DimFilter dimFilter) {
        return Druids.TimeseriesQueryBuilder.copy(this).filters(dimFilter).build();
    }

    public TimeseriesQuery withPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
        return Druids.TimeseriesQueryBuilder.copy(this).postAggregators(postAggregatorSpecs).build();
    }

    public String toString() {
        return "TimeseriesQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", descending=" + this.isDescending() + ", virtualColumns=" + this.virtualColumns + ", dimFilter=" + this.dimFilter + ", granularity='" + this.getGranularity() + '\'' + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", context=" + this.getContext() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeseriesQuery that = (TimeseriesQuery)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.aggregatorSpecs, that.aggregatorSpecs) && Objects.equals(this.postAggregatorSpecs, that.postAggregatorSpecs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.virtualColumns, this.dimFilter, this.aggregatorSpecs, this.postAggregatorSpecs);
    }
}

