/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import io.druid.java.util.common.granularity.AllGranularity;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.nary.BinaryFn;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.util.LinkedHashMap;
import java.util.List;

public class TimeseriesBinaryFn
implements BinaryFn<Result<TimeseriesResultValue>, Result<TimeseriesResultValue>, Result<TimeseriesResultValue>> {
    private final Granularity gran;
    private final List<AggregatorFactory> aggregations;

    public TimeseriesBinaryFn(Granularity granularity, List<AggregatorFactory> aggregations) {
        this.gran = granularity;
        this.aggregations = aggregations;
    }

    public Result<TimeseriesResultValue> apply(Result<TimeseriesResultValue> arg1, Result<TimeseriesResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        TimeseriesResultValue arg1Val = arg1.getValue();
        TimeseriesResultValue arg2Val = arg2.getValue();
        LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>();
        for (AggregatorFactory factory : this.aggregations) {
            String metricName = factory.getName();
            retVal.put(metricName, factory.combine(arg1Val.getMetric(metricName), arg2Val.getMetric(metricName)));
        }
        return this.gran instanceof AllGranularity ? new Result<TimeseriesResultValue>(arg1.getTimestamp(), new TimeseriesResultValue(retVal)) : new Result<TimeseriesResultValue>(this.gran.bucketStart(arg1.getTimestamp()), new TimeseriesResultValue(retVal));
    }
}

