/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Json;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.timeseries.DefaultTimeseriesQueryMetrics;
import io.druid.query.timeseries.TimeseriesQueryMetrics;
import io.druid.query.timeseries.TimeseriesQueryMetricsFactory;

@LazySingleton
public class DefaultTimeseriesQueryMetricsFactory
implements TimeseriesQueryMetricsFactory {
    private static final TimeseriesQueryMetricsFactory INSTANCE = new DefaultTimeseriesQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static TimeseriesQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultTimeseriesQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TimeseriesQueryMetrics makeMetrics() {
        return new DefaultTimeseriesQueryMetrics(this.jsonMapper);
    }
}

