/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.Cursor;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumns;
import io.druid.segment.filter.Filters;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.DateTime;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest toolChest = new TimeBoundaryQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeBoundaryQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return toolChest;
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final StorageAdapter adapter;
        private final Function<Cursor, Result<DateTime>> skipToFirstMatching;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
            this.skipToFirstMatching = new Function<Cursor, Result<DateTime>>(){

                public Result<DateTime> apply(Cursor cursor) {
                    if (cursor.isDone()) {
                        return null;
                    }
                    ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                    DateTime timestamp = DateTimes.utc((long)timestampColumnSelector.getLong());
                    return new Result<DateTime>(adapter.getInterval().getStart(), timestamp);
                }
            };
        }

        private DateTime getTimeBoundary(StorageAdapter adapter, TimeBoundaryQuery legacyQuery, boolean descending) {
            Sequence<Result<DateTime>> resultSequence = QueryRunnerHelper.makeCursorBasedQuery(adapter, legacyQuery.getQuerySegmentSpec().getIntervals(), Filters.toFilter(legacyQuery.getFilter()), VirtualColumns.EMPTY, descending, Granularities.ALL, this.skipToFirstMatching);
            List resultList = Sequences.toList((Sequence)Sequences.limit(resultSequence, (int)1), (List)Lists.newArrayList());
            if (resultList.size() > 0) {
                return (DateTime)((Result)resultList.get(0)).getValue();
            }
            return null;
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, Map<String, Object> responseContext) {
            Query<Result<TimeBoundaryResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TimeBoundaryQuery.class});
            }
            final TimeBoundaryQuery legacyQuery = (TimeBoundaryQuery)input;
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    DateTime maxTime;
                    DateTime minTime;
                    if (adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    if (legacyQuery.getFilter() != null) {
                        minTime = this.getTimeBoundary(adapter, legacyQuery, false);
                        maxTime = minTime == null ? null : this.getTimeBoundary(adapter, legacyQuery, true);
                    } else {
                        minTime = legacyQuery.getBound().equalsIgnoreCase("maxTime") ? null : adapter.getMinTime();
                        maxTime = legacyQuery.getBound().equalsIgnoreCase("minTime") ? null : adapter.getMaxTime();
                    }
                    return legacyQuery.buildResult(adapter.getInterval().getStart(), minTime, maxTime).iterator();
                }

                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

