/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryEngine;
import io.druid.query.select.SelectQueryQueryToolChest;
import io.druid.query.select.SelectResultValue;
import io.druid.segment.Segment;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class SelectQueryRunnerFactory
implements QueryRunnerFactory<Result<SelectResultValue>, SelectQuery> {
    private final SelectQueryQueryToolChest toolChest;
    private final SelectQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public SelectQueryRunnerFactory(SelectQueryQueryToolChest toolChest, SelectQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> createRunner(Segment segment) {
        return new SelectQueryRunner(this.engine, segment);
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SelectResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SelectResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SelectResultValue>, SelectQuery> getToolchest() {
        return this.toolChest;
    }

    private static class SelectQueryRunner
    implements QueryRunner<Result<SelectResultValue>> {
        private final SelectQueryEngine engine;
        private final Segment segment;

        private SelectQueryRunner(SelectQueryEngine engine, Segment segment) {
            this.engine = engine;
            this.segment = segment;
        }

        @Override
        public Sequence<Result<SelectResultValue>> run(QueryPlus<Result<SelectResultValue>> queryPlus, Map<String, Object> responseContext) {
            Query<Result<SelectResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof SelectQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SelectQuery.class});
            }
            return this.engine.process((SelectQuery)input, this.segment);
        }
    }
}

