/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.nary.BinaryFn;
import io.druid.query.CacheStrategy;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.select.DefaultSelectQueryMetricsFactory;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectBinaryFn;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryConfig;
import io.druid.query.select.SelectQueryMetrics;
import io.druid.query.select.SelectQueryMetricsFactory;
import io.druid.query.select.SelectResultValue;
import io.druid.timeline.DataSegmentUtils;
import io.druid.timeline.LogicalSegment;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SelectQueryQueryToolChest
extends QueryToolChest<Result<SelectResultValue>, SelectQuery> {
    private static final byte SELECT_QUERY = 22;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<SelectResultValue>> TYPE_REFERENCE = new TypeReference<Result<SelectResultValue>>(){};
    private final ObjectMapper jsonMapper;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final SelectQueryMetricsFactory queryMetricsFactory;

    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier) {
        this(jsonMapper, intervalChunkingQueryRunnerDecorator, configSupplier, DefaultSelectQueryMetricsFactory.instance());
    }

    @Inject
    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier, SelectQueryMetricsFactory queryMetricsFactory) {
        this.jsonMapper = jsonMapper;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeResults(QueryRunner<Result<SelectResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<SelectResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<SelectResultValue>> makeOrdering(Query<Result<SelectResultValue>> query) {
                return ResultGranularTimestampComparator.create(((SelectQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<SelectResultValue>, Result<SelectResultValue>, Result<SelectResultValue>> createMergeFn(Query<Result<SelectResultValue>> input) {
                SelectQuery query = (SelectQuery)input;
                return new SelectBinaryFn(query.getGranularity(), query.getPagingSpec(), query.isDescending());
            }
        };
    }

    public SelectQueryMetrics makeMetrics(SelectQuery query) {
        SelectQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics(query);
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<SelectResultValue>, Result<SelectResultValue>> makePreComputeManipulatorFn(SelectQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SelectResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SelectResultValue>, Object, SelectQuery> getCacheStrategy(final SelectQuery query) {
        return new CacheStrategy<Result<SelectResultValue>, Object, SelectQuery>(){
            private final List<DimensionSpec> dimensionSpecs;
            private final List<String> dimOutputNames;
            {
                this.dimensionSpecs = query.getDimensions() != null ? query.getDimensions() : Collections.emptyList();
                this.dimOutputNames = this.dimensionSpecs.size() > 0 ? Lists.transform(this.dimensionSpecs, DimensionSpec::getOutputName) : Collections.emptyList();
            }

            @Override
            public boolean isCacheable(SelectQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SelectQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] granularityBytes = query2.getGranularity().getCacheKey();
                List<Object> dimensionSpecs = query2.getDimensions() != null ? query2.getDimensions() : Collections.emptyList();
                byte[][] dimensionsBytes = new byte[dimensionSpecs.size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimensionSpec : dimensionSpecs) {
                    dimensionsBytes[index] = dimensionSpec.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                TreeSet metrics = Sets.newTreeSet();
                if (query2.getMetrics() != null) {
                    metrics.addAll(query2.getMetrics());
                }
                byte[][] byArrayArray = new byte[metrics.size()][];
                int metricBytesSize = 0;
                index = 0;
                for (String metric : metrics) {
                    byArrayArray[index] = StringUtils.toUtf8((String)metric);
                    metricBytesSize += byArrayArray[index].length;
                    ++index;
                }
                byte[] virtualColumnsCacheKey = query2.getVirtualColumns().getCacheKey();
                byte isDescendingByte = query2.isDescending() ? (byte)1 : 0;
                ByteBuffer queryCacheKey = ByteBuffer.allocate(2 + granularityBytes.length + filterBytes.length + query2.getPagingSpec().getCacheKey().length + dimensionsBytesSize + metricBytesSize + virtualColumnsCacheKey.length).put((byte)22).put(granularityBytes).put(filterBytes).put(query2.getPagingSpec().getCacheKey()).put(isDescendingByte);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    queryCacheKey.put(dimensionsByte);
                }
                for (byte[] metricByte : byArrayArray) {
                    queryCacheKey.put(metricByte);
                }
                queryCacheKey.put(virtualColumnsCacheKey);
                return queryCacheKey.array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SelectResultValue>, Object> prepareForCache() {
                return new Function<Result<SelectResultValue>, Object>(){

                    public Object apply(Result<SelectResultValue> input) {
                        if (!dimOutputNames.isEmpty()) {
                            return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents(), dimOutputNames);
                        }
                        return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents());
                    }
                };
            }

            @Override
            public Function<Object, Result<SelectResultValue>> pullFromCache() {
                return new Function<Object, Result<SelectResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<SelectResultValue> apply(Object input) {
                        List results = (List)input;
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        Map pageIdentifier = (Map)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                        Set dimensionSet = (Set)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Set<String>>(){});
                        Set metricSet = (Set)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Set<String>>(){});
                        List eventHolders = (List)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<List<EventHolder>>(){});
                        if (resultIter.hasNext()) {
                            List cachedOutputNames = (List)resultIter.next();
                            Preconditions.checkArgument((cachedOutputNames.size() == dimOutputNames.size() ? 1 : 0) != 0, (Object)"Cache hit but different number of dimensions??");
                            for (int idx = 0; idx < dimOutputNames.size(); ++idx) {
                                if (((String)cachedOutputNames.get(idx)).equals(dimOutputNames.get(idx))) continue;
                                for (EventHolder eventHolder : eventHolders) {
                                    Object obj = eventHolder.getEvent().remove(cachedOutputNames.get(idx));
                                    if (obj == null) continue;
                                    eventHolder.getEvent().put((String)dimOutputNames.get(idx), obj);
                                }
                            }
                        }
                        return new Result<SelectResultValue>(timestamp, new SelectResultValue(pageIdentifier, dimensionSet, metricSet, eventHolders));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> preMergeQueryDecoration(final QueryRunner<Result<SelectResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<SelectResultValue>>(){

            @Override
            public Sequence<Result<SelectResultValue>> run(QueryPlus<Result<SelectResultValue>> queryPlus, Map<String, Object> responseContext) {
                SelectQuery selectQuery = (SelectQuery)queryPlus.getQuery();
                if (selectQuery.getDimensionsFilter() != null) {
                    selectQuery = selectQuery.withDimFilter(selectQuery.getDimensionsFilter().optimize());
                    queryPlus = queryPlus.withQuery(selectQuery);
                }
                return runner.run(queryPlus, responseContext);
            }
        }, this);
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SelectQuery query, List<T> segments) {
        final String dataSource = (String)Iterables.getOnlyElement(query.getDataSource().getNames());
        PagingSpec pagingSpec = query.getPagingSpec();
        Map<String, Integer> paging = pagingSpec.getPagingIdentifiers();
        if (paging == null || paging.isEmpty()) {
            return segments;
        }
        Granularity granularity = query.getGranularity();
        Iterable filteredPagingKeys = Iterables.filter(paging.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return DataSegmentUtils.valueOf((String)dataSource, (String)input) != null;
            }
        });
        ArrayList intervals = Lists.newArrayList((Iterable)Iterables.transform((Iterable)filteredPagingKeys, (Function)DataSegmentUtils.INTERVAL_EXTRACTOR((String)dataSource)));
        Collections.sort(intervals, query.isDescending() ? Comparators.intervalsByEndThenStart() : Comparators.intervalsByStartThenEnd());
        TreeMap granularThresholds = Maps.newTreeMap();
        for (Interval interval : intervals) {
            if (query.isDescending()) {
                long granularEnd = granularity.bucketStart(interval.getEnd()).getMillis();
                Long currentEnd = (Long)granularThresholds.get(granularEnd);
                if (currentEnd != null && interval.getEndMillis() <= currentEnd) continue;
                granularThresholds.put(granularEnd, interval.getEndMillis());
                continue;
            }
            long granularStart = granularity.bucketStart(interval.getStart()).getMillis();
            Long currentStart = (Long)granularThresholds.get(granularStart);
            if (currentStart != null && interval.getStartMillis() >= currentStart) continue;
            granularThresholds.put(granularStart, interval.getStartMillis());
        }
        ArrayList queryIntervals = Lists.newArrayList(segments);
        Iterator it = queryIntervals.iterator();
        if (query.isDescending()) {
            while (it.hasNext()) {
                Interval interval = ((LogicalSegment)it.next()).getInterval();
                Map.Entry ceiling = granularThresholds.ceilingEntry(granularity.bucketStart(interval.getEnd()).getMillis());
                if (ceiling != null && interval.getStartMillis() < (Long)ceiling.getValue()) continue;
                it.remove();
            }
        } else {
            while (it.hasNext()) {
                Interval interval = ((LogicalSegment)it.next()).getInterval();
                Map.Entry floor = granularThresholds.floorEntry(granularity.bucketStart(interval.getStart()).getMillis());
                if (floor != null && interval.getEndMillis() > (Long)floor.getValue()) continue;
                it.remove();
            }
        }
        return queryIntervals;
    }
}

