/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.ColumnSelectorPlus;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.Result;
import io.druid.query.dimension.ColumnSelectorStrategy;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.Filter;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingOffset;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectResultValue;
import io.druid.query.select.SelectResultValueBuilder;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.BaseFloatColumnValueSelector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.BaseObjectColumnValueSelector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionHandlerUtils;
import io.druid.segment.DimensionSelector;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import io.druid.timeline.DataSegmentUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;

public class SelectQueryEngine {
    private static final SelectStrategyFactory STRATEGY_FACTORY = new SelectStrategyFactory();

    public Sequence<Result<SelectResultValue>> process(final SelectQuery query, Segment segment) {
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        String dataSource = (String)Iterables.getOnlyElement(query.getDataSource().getNames());
        final List<DimensionSpec> dims = query.getDimensions() == null || query.getDimensions().isEmpty() ? DefaultDimensionSpec.toSpec(adapter.getAvailableDimensions()) : query.getDimensions();
        final Iterable<String> metrics = query.getMetrics() == null || query.getMetrics().isEmpty() ? adapter.getAvailableMetrics() : query.getMetrics();
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{intervals});
        final String segmentId = DataSegmentUtils.withInterval((String)dataSource, (String)segment.getIdentifier(), (Interval)intervals.get(0));
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, query.getQuerySegmentSpec().getIntervals(), filter, query.getVirtualColumns(), query.isDescending(), query.getGranularity(), new Function<Cursor, Result<SelectResultValue>>(){

            public Result<SelectResultValue> apply(Cursor cursor) {
                SelectResultValueBuilder builder = new SelectResultValueBuilder(cursor.getTime(), query.getPagingSpec(), query.isDescending());
                ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList = Arrays.asList(DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, Lists.newArrayList((Iterable)dims), cursor.getColumnSelectorFactory()));
                for (Object dimSpec : dims) {
                    builder.addDimension(dimSpec.getOutputName());
                }
                HashMap metSelectors = Maps.newHashMap();
                for (String metric : metrics) {
                    ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                    metSelectors.put(metric, metricSelector);
                    builder.addMetric(metric);
                }
                PagingOffset offset = query.getPagingOffset(segmentId);
                cursor.advanceTo(offset.startDelta());
                int lastOffset = offset.startOffset();
                while (!cursor.isDone() && offset.hasNext()) {
                    Map<String, Object> theEvent = SelectQueryEngine.singleEvent("timestamp", timestampColumnSelector, selectorPlusList, metSelectors);
                    lastOffset = offset.current();
                    builder.addEntry(new EventHolder(segmentId, lastOffset, theEvent));
                    cursor.advance();
                    offset.next();
                }
                builder.finished(segmentId, lastOffset);
                return builder.build();
            }
        });
    }

    public static Map<String, Object> singleEvent(String timestampKey, BaseLongColumnValueSelector timestampColumnSelector, List<ColumnSelectorPlus<SelectColumnSelectorStrategy>> selectorPlusList, Map<String, BaseObjectColumnValueSelector<?>> metSelectors) {
        LinkedHashMap theEvent = Maps.newLinkedHashMap();
        theEvent.put(timestampKey, DateTimes.utc((long)timestampColumnSelector.getLong()));
        for (ColumnSelectorPlus<SelectColumnSelectorStrategy> columnSelectorPlus : selectorPlusList) {
            columnSelectorPlus.getColumnSelectorStrategy().addRowValuesToSelectResult(columnSelectorPlus.getOutputName(), columnSelectorPlus.getSelector(), theEvent);
        }
        for (Map.Entry entry : metSelectors.entrySet()) {
            String metric = (String)entry.getKey();
            BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)entry.getValue();
            if (selector == null) {
                theEvent.put(metric, null);
                continue;
            }
            theEvent.put(metric, selector.getObject());
        }
        return theEvent;
    }

    public static class DoubleSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseDoubleColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, selector.getDouble());
            }
        }
    }

    public static class FloatSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseFloatColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseFloatColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, Float.valueOf(selector.getFloat()));
            }
        }
    }

    public static class LongSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<BaseLongColumnValueSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, BaseLongColumnValueSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                resultMap.put(outputName, selector.getLong());
            }
        }
    }

    public static class StringSelectColumnSelectorStrategy
    implements SelectColumnSelectorStrategy<DimensionSelector> {
        @Override
        public void addRowValuesToSelectResult(String outputName, DimensionSelector selector, Map<String, Object> resultMap) {
            if (selector == null) {
                resultMap.put(outputName, null);
            } else {
                IndexedInts vals = selector.getRow();
                if (vals.size() == 1) {
                    String dimVal = selector.lookupName(vals.get(0));
                    resultMap.put(outputName, dimVal);
                } else {
                    ArrayList<String> dimVals = new ArrayList<String>(vals.size());
                    for (int i = 0; i < vals.size(); ++i) {
                        dimVals.add(selector.lookupName(vals.get(i)));
                    }
                    resultMap.put(outputName, dimVals);
                }
            }
        }
    }

    public static interface SelectColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public void addRowValuesToSelectResult(String var1, ValueSelectorType var2, Map<String, Object> var3);
    }

    public static class SelectStrategyFactory
    implements ColumnSelectorStrategyFactory<SelectColumnSelectorStrategy> {
        @Override
        public SelectColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringSelectColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongSelectColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatSelectColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleSelectColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

