/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.query.search.AutoStrategy;
import io.druid.query.search.CursorOnlyStrategy;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryConfig;
import io.druid.query.search.SearchStrategy;
import io.druid.query.search.UseIndexesStrategy;

public class SearchStrategySelector {
    private static final EmittingLogger log = new EmittingLogger(SearchStrategySelector.class);
    private final SearchQueryConfig config;

    @Inject
    public SearchStrategySelector(Supplier<SearchQueryConfig> configSupplier) {
        this.config = (SearchQueryConfig)configSupplier.get();
    }

    public SearchStrategy strategize(SearchQuery query) {
        String strategyString;
        switch (strategyString = this.config.withOverrides(query).getSearchStrategy()) {
            case "auto": {
                log.debug("Auto strategy is selected, query id [%s]", new Object[]{query.getId()});
                return AutoStrategy.of(query);
            }
            case "useIndexes": {
                log.debug("Use-index strategy is selected, query id [%s]", new Object[]{query.getId()});
                return UseIndexesStrategy.of(query);
            }
            case "cursorOnly": {
                log.debug("Cursor-only strategy is selected, query id [%s]", new Object[]{query.getId()});
                return CursorOnlyStrategy.of(query);
            }
        }
        throw new ISE("Unknown strategy[%s], query id [%s]", new Object[]{strategyString, query.getId()});
    }
}

