/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.collections.bitmap.RoaringBitmapFactory;
import io.druid.java.util.common.IAE;
import io.druid.query.Druids;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.Filter;
import io.druid.query.search.ConciseBitmapDecisionHelper;
import io.druid.query.search.RoaringBitmapDecisionHelper;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryDecisionHelper;
import io.druid.query.search.SearchQueryExecutor;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.Filters;
import java.util.List;
import org.joda.time.Interval;

public abstract class SearchStrategy {
    protected final Filter filter;
    protected final Interval interval;

    protected SearchStrategy(SearchQuery query) {
        this.filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", new Object[]{intervals});
        }
        this.interval = intervals.get(0);
    }

    public abstract List<SearchQueryExecutor> getExecutionPlan(SearchQuery var1, Segment var2);

    public SearchQueryDecisionHelper getDecisionHelper(QueryableIndex index) {
        BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
        if (bitmapFactory.getClass().equals(ConciseBitmapFactory.class)) {
            return ConciseBitmapDecisionHelper.instance();
        }
        if (bitmapFactory.getClass().equals(RoaringBitmapFactory.class)) {
            return RoaringBitmapDecisionHelper.instance();
        }
        throw new IAE("Unknown bitmap type[%s]", new Object[]{bitmapFactory.getClass().getCanonicalName()});
    }

    static List<DimensionSpec> getDimsToSearch(Indexed<String> availableDimensions, List<DimensionSpec> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            return ImmutableList.copyOf((Iterable)Iterables.transform(availableDimensions, Druids.DIMENSION_IDENTITY));
        }
        return dimensions;
    }
}

