/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.FunctionalIterable;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.dimension.ColumnSelectorStrategy;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.query.search.SearchHit;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryExecutor;
import io.druid.query.search.SearchQuerySpec;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.SearchStrategySelector;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.BaseFloatColumnValueSelector;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.Segment;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.List;
import java.util.Map;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    public static final SearchColumnSelectorStrategyFactory SEARCH_COLUMN_SELECTOR_STRATEGY_FACTORY = new SearchColumnSelectorStrategyFactory();
    private final Segment segment;
    private final SearchStrategySelector strategySelector;

    public SearchQueryRunner(Segment segment, SearchStrategySelector strategySelector) {
        this.segment = segment;
        this.strategySelector = strategySelector;
    }

    private static boolean isNilSelector(DimensionSelector selector) {
        return selector.nameLookupPossibleInAdvance() && selector.getValueCardinality() == 1 && selector.lookupName(0) == null;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(QueryPlus<Result<SearchResultValue>> queryPlus, Map<String, Object> responseContext) {
        Query<Result<SearchResultValue>> input = queryPlus.getQuery();
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SearchQuery.class});
        }
        SearchQuery query = (SearchQuery)input;
        List<SearchQueryExecutor> plan = this.strategySelector.strategize(query).getExecutionPlan(query, this.segment);
        Object2IntRBTreeMap retVal = new Object2IntRBTreeMap(query.getSort().getComparator());
        retVal.defaultReturnValue(0);
        int remain = query.getLimit();
        for (SearchQueryExecutor executor : plan) {
            retVal.putAll(executor.execute(remain));
            remain -= retVal.size();
        }
        return SearchQueryRunner.makeReturnResult(this.segment, query.getLimit(), (Object2IntRBTreeMap<SearchHit>)retVal);
    }

    private static Sequence<Result<SearchResultValue>> makeReturnResult(Segment segment, int limit, Object2IntRBTreeMap<SearchHit> retVal) {
        Iterable source = Iterables.transform((Iterable)retVal.object2IntEntrySet(), (Function)new Function<Object2IntMap.Entry<SearchHit>, SearchHit>(){

            public SearchHit apply(Object2IntMap.Entry<SearchHit> input) {
                SearchHit hit = (SearchHit)input.getKey();
                return new SearchHit(hit.getDimension(), hit.getValue(), input.getIntValue());
            }
        });
        return Sequences.simple((Iterable)ImmutableList.of(new Result<SearchResultValue>(segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList((Iterable)new FunctionalIterable(source).limit(limit))))));
    }

    public static class DoubleSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseDoubleColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getDouble()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class FloatSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseFloatColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseFloatColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getFloat()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class LongSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseLongColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseLongColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getLong()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class StringSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<DimensionSelector> {
        @Override
        public void updateSearchResultSet(String outputName, DimensionSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            if (selector != null && !SearchQueryRunner.isNilSelector(selector)) {
                IndexedInts vals = selector.getRow();
                for (int i = 0; i < vals.size(); ++i) {
                    String dimVal = selector.lookupName(vals.get(i));
                    if (!searchQuerySpec.accept(dimVal)) continue;
                    set.addTo((Object)new SearchHit(outputName, Strings.nullToEmpty((String)dimVal)), 1);
                    if (set.size() < limit) continue;
                    return;
                }
            }
        }
    }

    public static interface SearchColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public void updateSearchResultSet(String var1, ValueSelectorType var2, SearchQuerySpec var3, int var4, Object2IntRBTreeMap<SearchHit> var5);
    }

    private static class SearchColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<SearchColumnSelectorStrategy> {
        private SearchColumnSelectorStrategyFactory() {
        }

        @Override
        public SearchColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringSearchColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongSearchColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatSearchColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleSearchColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

