/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.search.SearchQuery;
import javax.validation.constraints.Min;

public class SearchQueryConfig {
    public static final String CTX_KEY_STRATEGY = "searchStrategy";
    @JsonProperty
    @Min(value=1L)
    private int maxSearchLimit = 1000;
    @JsonProperty
    private String searchStrategy = "useIndexes";

    public int getMaxSearchLimit() {
        return this.maxSearchLimit;
    }

    public String getSearchStrategy() {
        return this.searchStrategy;
    }

    public void setSearchStrategy(String strategy) {
        this.searchStrategy = strategy;
    }

    public SearchQueryConfig withOverrides(SearchQuery query) {
        SearchQueryConfig newConfig = new SearchQueryConfig();
        newConfig.maxSearchLimit = query.getLimit();
        newConfig.searchStrategy = query.getContextValue(CTX_KEY_STRATEGY, this.searchStrategy);
        return newConfig;
    }
}

