/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.druid.query.DefaultGenericQueryMetricsFactory;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.search.DefaultSearchQueryMetrics;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryMetrics;
import io.druid.query.search.SearchQueryMetricsFactory;

public class DefaultSearchQueryMetricsFactory
implements SearchQueryMetricsFactory {
    private static final SearchQueryMetricsFactory INSTANCE = new DefaultSearchQueryMetricsFactory(DefaultGenericQueryMetricsFactory.instance());
    private final GenericQueryMetricsFactory genericQueryMetricsFactory;

    @Inject
    public DefaultSearchQueryMetricsFactory(GenericQueryMetricsFactory genericQueryMetricsFactory) {
        this.genericQueryMetricsFactory = genericQueryMetricsFactory;
    }

    @VisibleForTesting
    public static SearchQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Override
    public SearchQueryMetrics makeMetrics(SearchQuery query) {
        return new DefaultSearchQueryMetrics(this.genericQueryMetricsFactory.makeMetrics(query));
    }
}

