/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import io.druid.java.util.emitter.EmittingLogger;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.search.CursorOnlyStrategy;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryDecisionHelper;
import io.druid.query.search.SearchQueryExecutor;
import io.druid.query.search.SearchStrategy;
import io.druid.query.search.UseIndexesStrategy;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import java.util.List;

public class AutoStrategy
extends SearchStrategy {
    public static final String NAME = "auto";
    private static final EmittingLogger log = new EmittingLogger(AutoStrategy.class);

    public static AutoStrategy of(SearchQuery query) {
        return new AutoStrategy(query);
    }

    private AutoStrategy(SearchQuery query) {
        super(query);
    }

    @Override
    public List<SearchQueryExecutor> getExecutionPlan(SearchQuery query, Segment segment) {
        QueryableIndex index = segment.asQueryableIndex();
        if (index != null) {
            ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(index.getBitmapFactoryForDimensions(), VirtualColumns.EMPTY, index);
            if (this.filter == null || this.filter.supportsSelectivityEstimation(index, selector)) {
                List<DimensionSpec> dimsToSearch = AutoStrategy.getDimsToSearch(index.getAvailableDimensions(), query.getDimensions());
                SearchQueryDecisionHelper helper = this.getDecisionHelper(index);
                double useIndexStrategyCost = helper.getBitmapIntersectCost() * (double)AutoStrategy.computeTotalCard(index, dimsToSearch);
                double cursorOnlyStrategyCost = (this.filter == null ? 1.0 : this.filter.estimateSelectivity(selector)) * (double)selector.getNumRows() * (double)dimsToSearch.size();
                log.debug("Use-index strategy cost: %f, cursor-only strategy cost: %f", new Object[]{useIndexStrategyCost, cursorOnlyStrategyCost});
                if (useIndexStrategyCost < cursorOnlyStrategyCost) {
                    log.debug("Use-index execution strategy is selected, query id [%s]", new Object[]{query.getId()});
                    return UseIndexesStrategy.of(query).getExecutionPlan(query, segment);
                }
                log.debug("Cursor-only execution strategy is selected, query id [%s]", new Object[]{query.getId()});
                return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
            }
            log.debug("Filter doesn't support bitmap index. Fall back to cursor-only execution strategy, query id [%s]", new Object[]{query.getId()});
            return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
        }
        log.debug("Index doesn't exist. Fall back to cursor-only execution strategy, query id [%s]", new Object[]{query.getId()});
        return CursorOnlyStrategy.of(query).getExecutionPlan(query, segment);
    }

    private static long computeTotalCard(QueryableIndex index, Iterable<DimensionSpec> dimensionSpecs) {
        long totalCard = 0L;
        for (DimensionSpec dimension : dimensionSpecs) {
            BitmapIndex bitmapIndex;
            Column column = index.getColumn(dimension.getDimension());
            if (column == null || (bitmapIndex = column.getBitmapIndex()) == null) continue;
            totalCard += (long)bitmapIndex.getCardinality();
        }
        return totalCard;
    }
}

