/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.scan;

import com.google.common.base.Function;
import com.google.inject.Inject;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.scan.ScanQuery;
import io.druid.query.scan.ScanQueryEngine;
import io.druid.query.scan.ScanQueryQueryToolChest;
import io.druid.query.scan.ScanResultValue;
import io.druid.segment.Segment;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ScanQueryRunnerFactory
implements QueryRunnerFactory<ScanResultValue, ScanQuery> {
    public static final String CTX_TIMEOUT_AT = "timeoutAt";
    public static final String CTX_COUNT = "count";
    private final ScanQueryQueryToolChest toolChest;
    private final ScanQueryEngine engine;

    @Inject
    public ScanQueryRunnerFactory(ScanQueryQueryToolChest toolChest, ScanQueryEngine engine) {
        this.toolChest = toolChest;
        this.engine = engine;
    }

    @Override
    public QueryRunner<ScanResultValue> createRunner(Segment segment) {
        return new ScanQueryRunner(this.engine, segment);
    }

    @Override
    public QueryRunner<ScanResultValue> mergeRunners(ExecutorService queryExecutor, final Iterable<QueryRunner<ScanResultValue>> queryRunners) {
        return new QueryRunner<ScanResultValue>(){

            @Override
            public Sequence<ScanResultValue> run(final QueryPlus<ScanResultValue> queryPlus, final Map<String, Object> responseContext) {
                long timeoutAt = System.currentTimeMillis() + QueryContexts.getTimeout(queryPlus.getQuery());
                responseContext.put(ScanQueryRunnerFactory.CTX_TIMEOUT_AT, timeoutAt);
                return Sequences.concat((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)queryRunners), (Function)new Function<QueryRunner<ScanResultValue>, Sequence<ScanResultValue>>(){

                    public Sequence<ScanResultValue> apply(QueryRunner<ScanResultValue> input) {
                        return input.run(queryPlus, responseContext);
                    }
                }));
            }
        };
    }

    @Override
    public QueryToolChest<ScanResultValue, ScanQuery> getToolchest() {
        return this.toolChest;
    }

    private static class ScanQueryRunner
    implements QueryRunner<ScanResultValue> {
        private final ScanQueryEngine engine;
        private final Segment segment;

        public ScanQueryRunner(ScanQueryEngine engine, Segment segment) {
            this.engine = engine;
            this.segment = segment;
        }

        @Override
        public Sequence<ScanResultValue> run(QueryPlus<ScanResultValue> queryPlus, Map<String, Object> responseContext) {
            Query<ScanResultValue> query = queryPlus.getQuery();
            if (!(query instanceof ScanQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{query.getClass(), ScanQuery.class});
            }
            Number timeoutAt = (Number)responseContext.get(ScanQueryRunnerFactory.CTX_TIMEOUT_AT);
            if (timeoutAt == null || timeoutAt.longValue() == 0L) {
                responseContext.put(ScanQueryRunnerFactory.CTX_TIMEOUT_AT, 0x3FFFFFFFFFFFFFFFL);
            }
            return this.engine.process((ScanQuery)query, this.segment, responseContext);
        }
    }
}

