/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.scan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.inject.Inject;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.scan.ScanQuery;
import io.druid.query.scan.ScanQueryConfig;
import io.druid.query.scan.ScanQueryLimitRowIterator;
import io.druid.query.scan.ScanResultValue;
import java.io.Closeable;
import java.util.Map;

public class ScanQueryQueryToolChest
extends QueryToolChest<ScanResultValue, ScanQuery> {
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private final ScanQueryConfig scanQueryConfig;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public ScanQueryQueryToolChest(ScanQueryConfig scanQueryConfig, GenericQueryMetricsFactory queryMetricsFactory) {
        this.scanQueryConfig = scanQueryConfig;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ScanResultValue> mergeResults(final QueryRunner<ScanResultValue> runner) {
        return new QueryRunner<ScanResultValue>(){

            @Override
            public Sequence<ScanResultValue> run(QueryPlus<ScanResultValue> queryPlus, final Map<String, Object> responseContext) {
                ScanQuery scanQuery = ((ScanQuery)queryPlus.getQuery()).withNonNullLegacy(ScanQueryQueryToolChest.this.scanQueryConfig);
                final QueryPlus<ScanResultValue> queryPlusWithNonNullLegacy = queryPlus.withQuery(scanQuery);
                if (scanQuery.getLimit() == Long.MAX_VALUE) {
                    return runner.run(queryPlusWithNonNullLegacy, responseContext);
                }
                return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ScanResultValue, ScanQueryLimitRowIterator>(){

                    public ScanQueryLimitRowIterator make() {
                        return new ScanQueryLimitRowIterator(runner, queryPlusWithNonNullLegacy, responseContext);
                    }

                    public void cleanup(ScanQueryLimitRowIterator iterFromMake) {
                        CloseQuietly.close((Closeable)((Object)iterFromMake));
                    }
                });
            }
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(ScanQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<ScanResultValue, ScanResultValue> makePreComputeManipulatorFn(ScanQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<ScanResultValue> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<ScanResultValue> preMergeQueryDecoration(final QueryRunner<ScanResultValue> runner) {
        return new QueryRunner<ScanResultValue>(){

            @Override
            public Sequence<ScanResultValue> run(QueryPlus<ScanResultValue> queryPlus, Map<String, Object> responseContext) {
                ScanQuery scanQuery = (ScanQuery)queryPlus.getQuery();
                if (scanQuery.getFilter() != null) {
                    scanQuery = scanQuery.withDimFilter(scanQuery.getFilter().optimize());
                    queryPlus = queryPlus.withQuery(scanQuery);
                }
                return runner.run(queryPlus, responseContext);
            }
        };
    }
}

