/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.scan;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.UOE;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.QueryContexts;
import io.druid.query.QueryInterruptedException;
import io.druid.query.filter.Filter;
import io.druid.query.scan.ScanQuery;
import io.druid.query.scan.ScanResultValue;
import io.druid.segment.BaseObjectColumnValueSelector;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.Cursor;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumn;
import io.druid.segment.filter.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class ScanQueryEngine {
    private static final String LEGACY_TIMESTAMP_KEY = "timestamp";

    public Sequence<ScanResultValue> process(final ScanQuery query, Segment segment, final Map<String, Object> responseContext) {
        long count;
        final boolean legacy = (Boolean)Preconditions.checkNotNull((Object)query.isLegacy(), (Object)"WTF?! Expected non-null legacy");
        if (responseContext.get("count") != null && (count = ((Long)responseContext.get("count")).longValue()) >= query.getLimit()) {
            return Sequences.empty();
        }
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = (Long)responseContext.get("timeoutAt");
        final long start = System.currentTimeMillis();
        StorageAdapter adapter = segment.asStorageAdapter();
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final ArrayList<String> allColumns = new ArrayList<String>();
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            if (legacy && !query.getColumns().contains(LEGACY_TIMESTAMP_KEY)) {
                allColumns.add(LEGACY_TIMESTAMP_KEY);
            }
            allColumns.addAll(query.getColumns());
        } else {
            LinkedHashSet availableColumns = Sets.newLinkedHashSet((Iterable)Iterables.concat(Collections.singleton(legacy ? LEGACY_TIMESTAMP_KEY : "__time"), (Iterable)Iterables.transform(Arrays.asList(query.getVirtualColumns().getVirtualColumns()), VirtualColumn::getOutputName), adapter.getAvailableDimensions(), adapter.getAvailableMetrics()));
            allColumns.addAll(availableColumns);
            if (legacy) {
                allColumns.remove("__time");
            }
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{intervals});
        final String segmentId = segment.getIdentifier();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()));
        if (responseContext.get("count") == null) {
            responseContext.put("count", 0L);
        }
        final long limit = query.getLimit() - (Long)responseContext.get("count");
        return Sequences.concat((Sequence)Sequences.map(adapter.makeCursors(filter, intervals.get(0), query.getVirtualColumns(), Granularities.ALL, query.isDescending(), null), (Function)new Function<Cursor, Sequence<ScanResultValue>>(){

            public Sequence<ScanResultValue> apply(final Cursor cursor) {
                return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ScanResultValue, Iterator<ScanResultValue>>(){

                    public Iterator<ScanResultValue> make() {
                        final ArrayList<ColumnValueSelector> columnSelectors = new ArrayList<ColumnValueSelector>(allColumns.size());
                        for (String column : allColumns) {
                            ColumnValueSelector selector = legacy && column.equals(ScanQueryEngine.LEGACY_TIMESTAMP_KEY) ? cursor.getColumnSelectorFactory().makeColumnValueSelector("__time") : cursor.getColumnSelectorFactory().makeColumnValueSelector(column);
                            columnSelectors.add(selector);
                        }
                        final int batchSize = query.getBatchSize();
                        return new Iterator<ScanResultValue>(){
                            private long offset = 0L;

                            @Override
                            public boolean hasNext() {
                                return !cursor.isDone() && this.offset < limit;
                            }

                            @Override
                            public ScanResultValue next() {
                                List<Object> events;
                                if (hasTimeout && System.currentTimeMillis() >= timeoutAt) {
                                    throw new QueryInterruptedException(new TimeoutException());
                                }
                                long lastOffset = this.offset;
                                String resultFormat = query.getResultFormat();
                                if ("compactedList".equals(resultFormat)) {
                                    events = this.rowsToCompactedList();
                                } else if ("list".equals(resultFormat)) {
                                    events = this.rowsToList();
                                } else {
                                    throw new UOE("resultFormat[%s] is not supported", new Object[]{resultFormat});
                                }
                                responseContext.put("count", (Long)responseContext.get("count") + (this.offset - lastOffset));
                                if (hasTimeout) {
                                    responseContext.put("timeoutAt", timeoutAt - (System.currentTimeMillis() - start));
                                }
                                return new ScanResultValue(segmentId, allColumns, events);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }

                            private List<Object> rowsToCompactedList() {
                                ArrayList<Object> events = new ArrayList<Object>(batchSize);
                                int i = 0;
                                while (!cursor.isDone() && i < batchSize && this.offset < limit) {
                                    ArrayList<Object> theEvent = new ArrayList<Object>(allColumns.size());
                                    for (int j = 0; j < allColumns.size(); ++j) {
                                        theEvent.add(this.getColumnValue(j));
                                    }
                                    events.add(theEvent);
                                    cursor.advance();
                                    ++i;
                                    ++this.offset;
                                }
                                return events;
                            }

                            private List<Map<String, Object>> rowsToList() {
                                ArrayList events = Lists.newArrayListWithCapacity((int)batchSize);
                                int i = 0;
                                while (!cursor.isDone() && i < batchSize && this.offset < limit) {
                                    LinkedHashMap theEvent = new LinkedHashMap();
                                    for (int j = 0; j < allColumns.size(); ++j) {
                                        theEvent.put(allColumns.get(j), this.getColumnValue(j));
                                    }
                                    events.add(theEvent);
                                    cursor.advance();
                                    ++i;
                                    ++this.offset;
                                }
                                return events;
                            }

                            private Object getColumnValue(int i) {
                                BaseObjectColumnValueSelector selector = (BaseObjectColumnValueSelector)columnSelectors.get(i);
                                DateTime value = legacy && ((String)allColumns.get(i)).equals(ScanQueryEngine.LEGACY_TIMESTAMP_KEY) ? DateTimes.utc((long)((Long)selector.getObject())) : (selector == null ? null : (DateTime)selector.getObject());
                                return value;
                            }
                        };
                    }

                    public void cleanup(Iterator<ScanResultValue> iterFromMake) {
                    }
                });
            }
        }));
    }
}

