/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.strategy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.druid.collections.BlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.ReferenceCountingResourceHolder;
import io.druid.collections.ResourceHolder;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Merging;
import io.druid.guice.annotations.Smile;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.guava.nary.BinaryFn;
import io.druid.query.DataSource;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.InsufficientResourcesException;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import io.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import io.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import io.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import io.druid.query.groupby.resource.GroupByQueryResource;
import io.druid.query.groupby.strategy.GroupByStrategy;
import io.druid.segment.StorageAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    public static final String CTX_KEY_OUTERMOST = "groupByOutermost";
    private static final int MAX_MERGE_BUFFER_NUM = 2;
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Global NonBlockingPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    public static DateTime getUniversalTimestamp(GroupByQuery query) {
        Granularity gran = query.getGranularity();
        String timestampStringFromContext = query.getContextValue(CTX_KEY_FUDGE_TIMESTAMP, "");
        if (!timestampStringFromContext.isEmpty()) {
            return DateTimes.utc((long)Long.parseLong(timestampStringFromContext));
        }
        if (Granularities.ALL.equals(gran)) {
            DateTime timeStart = query.getIntervals().get(0).getStart();
            return ((Interval)gran.getIterable(new Interval((ReadableInstant)timeStart, (ReadableInstant)timeStart.plus(1L))).iterator().next()).getStart();
        }
        return null;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query, boolean willMergeRunners) {
        if (!willMergeRunners) {
            int requiredMergeBufferNum = GroupByStrategyV2.countRequiredMergeBufferNum(query, 1);
            if (requiredMergeBufferNum > this.mergeBufferPool.maxSize()) {
                throw new ResourceLimitExceededException("Query needs " + requiredMergeBufferNum + " merge buffers, but only " + this.mergeBufferPool.maxSize() + " merge buffers are configured", new Object[0]);
            }
            if (requiredMergeBufferNum == 0) {
                return new GroupByQueryResource();
            }
            ReferenceCountingResourceHolder mergeBufferHolders = QueryContexts.hasTimeout(query) ? this.mergeBufferPool.takeBatch(requiredMergeBufferNum, QueryContexts.getTimeout(query)) : this.mergeBufferPool.takeBatch(requiredMergeBufferNum);
            if (mergeBufferHolders == null) {
                throw new InsufficientResourcesException("Cannot acquire enough merge buffers");
            }
            return new GroupByQueryResource((ResourceHolder<List<ByteBuffer>>)mergeBufferHolders);
        }
        return new GroupByQueryResource();
    }

    private static int countRequiredMergeBufferNum(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByStrategyV2.countRequiredMergeBufferNum(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return willMergeRunners;
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return true;
    }

    @Override
    public QueryRunner<Row> createIntervalChunkingRunner(IntervalChunkingQueryRunnerDecorator decorator, QueryRunner<Row> runner, GroupByQueryQueryToolChest toolChest) {
        return runner;
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, final GroupByQuery query, Map<String, Object> responseContext) {
        ResultMergeQueryRunner<Row> mergingQueryRunner = new ResultMergeQueryRunner<Row>(baseRunner){

            @Override
            protected Ordering<Row> makeOrdering(Query<Row> queryParam) {
                return ((GroupByQuery)queryParam).getRowOrdering(true);
            }

            @Override
            protected BinaryFn<Row, Row, Row> createMergeFn(Query<Row> queryParam) {
                return new GroupByBinaryFnV2((GroupByQuery)queryParam);
            }
        };
        final DateTime fudgeTimestamp = GroupByStrategyV2.getUniversalTimestamp(query);
        Query newQuery = new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getVirtualColumns(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), null, query.getLimitSpec(), query.getContext()).withOverriddenContext((Map)ImmutableMap.of((Object)"finalize", (Object)false, (Object)"groupByStrategy", (Object)"v2", (Object)CTX_KEY_FUDGE_TIMESTAMP, (Object)(fudgeTimestamp == null ? "" : String.valueOf(fudgeTimestamp.getMillis())), (Object)CTX_KEY_OUTERMOST, (Object)false, (Object)"applyLimitPushDown", (Object)query.isApplyLimitPushDown()));
        Sequence rowSequence = Sequences.map(mergingQueryRunner.run(QueryPlus.wrap(newQuery), responseContext), (Function)new Function<Row, Row>(){

            public Row apply(Row row) {
                Map newMap;
                if (!query.getContextBoolean(GroupByStrategyV2.CTX_KEY_OUTERMOST, true)) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty() && fudgeTimestamp == null) {
                    return row;
                }
                if (query.getPostAggregatorSpecs().isEmpty()) {
                    newMap = ((MapBasedRow)row).getEvent();
                } else {
                    newMap = Maps.newLinkedHashMap((Map)((MapBasedRow)row).getEvent());
                    for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
                        newMap.put(postAggregator.getName(), postAggregator.compute(newMap));
                    }
                }
                return new MapBasedRow(fudgeTimestamp != null ? fudgeTimestamp : row.getTimestamp(), newMap);
            }
        });
        if (query.getContextBoolean(CTX_KEY_OUTERMOST, true)) {
            return query.postProcess((Sequence<Row>)rowSequence);
        }
        return rowSequence;
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<Row> subqueryResult) {
        final Sequence<Row> results = GroupByRowProcessor.process(query, subqueryResult, GroupByQueryHelper.rowSignatureFor(subquery), (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
        return this.mergeResults(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                return results;
            }
        }, query, null);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergingQueryRunnerV2((GroupByQueryConfig)this.configSupplier.get(), (ExecutorService)exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.bufferPool, this.mergeBufferPool, this.processingConfig.intermediateComputeSizeBytes(), this.spillMapper, this.processingConfig.getTmpDir());
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query));
    }
}

