/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.druid.collections.NonBlockingPool;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.GroupByMergedQueryRunner;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.orderby.NoopLimitSpec;
import io.druid.query.groupby.resource.GroupByQueryResource;
import io.druid.query.groupby.strategy.GroupByStrategy;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.segment.StorageAdapter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class GroupByStrategyV1
implements GroupByStrategy {
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;
    private final NonBlockingPool<ByteBuffer> bufferPool;

    @Inject
    public GroupByStrategyV1(Supplier<GroupByQueryConfig> configSupplier, GroupByQueryEngine engine, QueryWatcher queryWatcher, @Global NonBlockingPool<ByteBuffer> bufferPool) {
        this.configSupplier = configSupplier;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
        this.bufferPool = bufferPool;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query, boolean willMergeRunners) {
        return new GroupByQueryResource();
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return true;
    }

    @Override
    public QueryRunner<Row> createIntervalChunkingRunner(IntervalChunkingQueryRunnerDecorator decorator, QueryRunner<Row> runner, GroupByQueryQueryToolChest toolChest) {
        return decorator.decorate(runner, toolChest);
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return query.getContextBoolean("groupByMerge", true);
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, GroupByQuery query, Map<String, Object> responseContext) {
        IncrementalIndex index = GroupByQueryHelper.makeIncrementalIndex(query, (GroupByQueryConfig)this.configSupplier.get(), this.bufferPool, baseRunner.run(QueryPlus.wrap(new GroupByQuery.Builder(query).setPostAggregatorSpecs((List<PostAggregator>)ImmutableList.of()).setHavingSpec(null).setLimitSpec(NoopLimitSpec.instance()).overrideContext((Map<String, Object>)ImmutableMap.of((Object)"finalize", (Object)false, (Object)"sortResults", (Object)false, (Object)"groupByMerge", (Object)false, (Object)"groupByStrategy", (Object)"v1")).build()), responseContext), true);
        return Sequences.withBaggage(query.postProcess(GroupByQueryHelper.postAggregate(query, index)), (Closeable)index);
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<Row> subqueryResult) {
        HashSet aggs = Sets.newHashSet();
        HashSet dimensionNames = Sets.newHashSet();
        for (DimensionSpec dimension : subquery.getDimensions()) {
            dimensionNames.add(dimension.getOutputName());
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            for (final AggregatorFactory transferAgg : aggregatorFactory.getRequiredColumns()) {
                if (dimensionNames.contains(transferAgg.getName())) continue;
                if (Iterables.any((Iterable)aggs, (Predicate)new Predicate<AggregatorFactory>(){

                    public boolean apply(AggregatorFactory agg) {
                        return agg.getName().equals(transferAgg.getName()) && !agg.equals(transferAgg);
                    }
                })) {
                    throw new IAE("Inner aggregator can currently only be referenced by a single type of outer aggregator for '%s'", new Object[]{transferAgg.getName()});
                }
                aggs.add(transferAgg);
            }
        }
        GroupByQuery innerQuery = new GroupByQuery.Builder(subquery).setAggregatorSpecs(Lists.newArrayList((Iterable)aggs)).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(Lists.newArrayList()).build();
        final GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
        final IncrementalIndex innerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex((GroupByQuery)innerQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)true)), (GroupByQueryConfig)this.configSupplier.get(), this.bufferPool, subqueryResult, false);
        IncrementalIndex outerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex(outerQuery, (GroupByQueryConfig)this.configSupplier.get(), this.bufferPool, (Sequence<Row>)Sequences.concat((Sequence)Sequences.map((Sequence)Sequences.simple(outerQuery.getIntervals()), (Function)new Function<Interval, Sequence<Row>>(){

            public Sequence<Row> apply(Interval interval) {
                return GroupByStrategyV1.this.process(outerQuery.withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)ImmutableList.of((Object)interval))), new IncrementalIndexStorageAdapter(innerQueryResultIndex));
            }
        })), true);
        innerQueryResultIndex.close();
        return Sequences.withBaggage(outerQuery.postProcess(GroupByQueryHelper.postAggregate(query, outerQueryResultIndex)), (Closeable)outerQueryResultIndex);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergedQueryRunner<Row>((ExecutorService)exec, this.configSupplier, this.queryWatcher, this.bufferPool, queryRunners);
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return this.engine.process(query, storageAdapter);
    }
}

