/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.resource;

import io.druid.collections.ResourceHolder;
import io.druid.java.util.common.logger.Logger;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;

public class GroupByQueryResource
implements Closeable {
    private static final Logger log = new Logger(GroupByQueryResource.class);
    private final ResourceHolder<List<ByteBuffer>> mergeBuffersHolder;
    private final Deque<ByteBuffer> mergeBuffers;

    public GroupByQueryResource() {
        this.mergeBuffersHolder = null;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>();
    }

    public GroupByQueryResource(ResourceHolder<List<ByteBuffer>> mergeBuffersHolder) {
        this.mergeBuffersHolder = mergeBuffersHolder;
        this.mergeBuffers = new ArrayDeque<ByteBuffer>((Collection)mergeBuffersHolder.get());
    }

    public ResourceHolder<ByteBuffer> getMergeBuffer() {
        final ByteBuffer buffer = this.mergeBuffers.pop();
        return new ResourceHolder<ByteBuffer>(){

            public ByteBuffer get() {
                return buffer;
            }

            public void close() {
                GroupByQueryResource.this.mergeBuffers.add(buffer);
            }
        };
    }

    @Override
    public void close() {
        if (this.mergeBuffersHolder != null) {
            if (this.mergeBuffers.size() != ((List)this.mergeBuffersHolder.get()).size()) {
                log.warn("%d resources are not returned yet", new Object[]{((List)this.mergeBuffersHolder.get()).size() - this.mergeBuffers.size()});
            }
            this.mergeBuffersHolder.close();
        }
    }
}

