/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.druid.data.input.Row;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.groupby.orderby.TopNSequence;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import io.druid.segment.column.ValueType;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultLimitSpec
implements LimitSpec {
    private static final byte CACHE_KEY = 1;
    private final List<OrderByColumnSpec> columns;
    private final int limit;

    public static boolean sortingOrderHasNonGroupingFields(DefaultLimitSpec limitSpec, List<DimensionSpec> dimensions) {
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, dimensions);
            if (dimIndex >= 0) continue;
            return true;
        }
        return false;
    }

    public static StringComparator getComparatorForDimName(DefaultLimitSpec limitSpec, String dimName) {
        OrderByColumnSpec orderBy = OrderByColumnSpec.getOrderByForDimName(limitSpec.getColumns(), dimName);
        if (orderBy == null) {
            return null;
        }
        return orderBy.getDimensionComparator();
    }

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"limit[%s] must be >0", (Object[])new Object[]{limit});
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    public boolean isLimited() {
        return this.limit < Integer.MAX_VALUE;
    }

    @Override
    public Function<Sequence<Row>, Sequence<Row>> build(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs, Granularity granularity, boolean sortByDimsFirst) {
        boolean sortingNeeded = dimensions.size() < this.columns.size();
        HashSet aggAndPostAggNames = Sets.newHashSet();
        for (AggregatorFactory agg : aggs) {
            aggAndPostAggNames.add(agg.getName());
        }
        for (PostAggregator postAgg : postAggs) {
            aggAndPostAggNames.add(postAgg.getName());
        }
        if (!sortingNeeded) {
            for (int i = 0; i < this.columns.size(); ++i) {
                StringComparator naturalComparator;
                OrderByColumnSpec columnSpec = this.columns.get(i);
                if (aggAndPostAggNames.contains(columnSpec.getDimension())) {
                    sortingNeeded = true;
                    break;
                }
                ValueType columnType = this.getOrderByType(columnSpec, dimensions);
                if (columnType == ValueType.STRING) {
                    naturalComparator = StringComparators.LEXICOGRAPHIC;
                } else if (ValueType.isNumeric(columnType)) {
                    naturalComparator = StringComparators.NUMERIC;
                } else {
                    sortingNeeded = true;
                    break;
                }
                if (columnSpec.getDirection() == OrderByColumnSpec.Direction.ASCENDING && columnSpec.getDimensionComparator().equals(naturalComparator) && columnSpec.getDimension().equals(dimensions.get(i).getOutputName())) continue;
                sortingNeeded = true;
                break;
            }
        }
        if (!sortingNeeded) {
            boolean bl = sortingNeeded = !granularity.equals(Granularities.ALL) && sortByDimsFirst;
        }
        if (!sortingNeeded) {
            return this.isLimited() ? new LimitingFn(this.limit) : Functions.identity();
        }
        Ordering<Row> ordering = this.makeComparator(dimensions, aggs, postAggs, sortByDimsFirst);
        if (this.isLimited()) {
            return new TopNFunction(ordering, this.limit);
        }
        return new SortingFn(ordering);
    }

    @Override
    public LimitSpec merge(LimitSpec other) {
        return this;
    }

    private ValueType getOrderByType(OrderByColumnSpec columnSpec, List<DimensionSpec> dimensions) {
        for (DimensionSpec dimSpec : dimensions) {
            if (!columnSpec.getDimension().equals(dimSpec.getOutputName())) continue;
            return dimSpec.getOutputType();
        }
        throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
    }

    /*
     * WARNING - void declaration
     */
    private Ordering<Row> makeComparator(List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs, boolean sortByDimsFirst) {
        void var9_18;
        void var9_14;
        Ordering<Row> timeOrdering = new Ordering<Row>(){

            public int compare(Row left, Row right) {
                return Longs.compare((long)left.getTimestampFromEpoch(), (long)right.getTimestampFromEpoch());
            }
        };
        HashMap dimensionsMap = Maps.newHashMap();
        for (DimensionSpec dimensionSpec : dimensions) {
            dimensionsMap.put(dimensionSpec.getOutputName(), dimensionSpec);
        }
        HashMap aggregatorsMap = Maps.newHashMap();
        for (AggregatorFactory aggregatorFactory : aggs) {
            aggregatorsMap.put(aggregatorFactory.getName(), aggregatorFactory);
        }
        HashMap hashMap = Maps.newHashMap();
        for (PostAggregator postAgg : postAggs) {
            hashMap.put(postAgg.getName(), postAgg);
        }
        Object var9_13 = null;
        for (OrderByColumnSpec columnSpec : this.columns) {
            String columnName = columnSpec.getDimension();
            Ordering nextOrdering = null;
            if (hashMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((PostAggregator)hashMap.get(columnName)).getComparator());
            } else if (aggregatorsMap.containsKey(columnName)) {
                nextOrdering = this.metricOrdering(columnName, ((AggregatorFactory)aggregatorsMap.get(columnName)).getComparator());
            } else if (dimensionsMap.containsKey(columnName)) {
                nextOrdering = this.dimensionOrdering(columnName, columnSpec.getDimensionComparator());
            }
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
            }
            if (columnSpec.getDirection() == OrderByColumnSpec.Direction.DESCENDING) {
                nextOrdering = nextOrdering.reverse();
            }
            Ordering ordering = var9_14 == null ? nextOrdering : var9_14.compound((Comparator)nextOrdering);
        }
        if (var9_14 != null) {
            Ordering ordering = sortByDimsFirst ? var9_14.compound((Comparator)timeOrdering) : timeOrdering.compound((Comparator)var9_14);
        } else {
            Ordering<Row> ordering = timeOrdering;
        }
        return var9_18;
    }

    private Ordering<Row> metricOrdering(String column, Comparator comparator) {
        return Ordering.from(Comparator.comparing(row -> row.getRaw(column), Comparator.nullsLast(comparator)));
    }

    private Ordering<Row> dimensionOrdering(String dimension, StringComparator comparator) {
        return Ordering.from(Comparator.comparing(row -> row.getDimension(dimension).isEmpty() ? null : (String)row.getDimension(dimension).get(0), Comparator.nullsFirst(comparator)));
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", limit=" + this.limit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLimitSpec that = (DefaultLimitSpec)o;
        if (this.limit != that.limit) {
            return false;
        }
        return !(this.columns != null ? !this.columns.equals(that.columns) : that.columns != null);
    }

    public int hashCode() {
        int result = this.columns != null ? this.columns.hashCode() : 0;
        result = 31 * result + this.limit;
        return result;
    }

    public byte[] getCacheKey() {
        byte[][] columnBytes = new byte[this.columns.size()][];
        int columnsBytesSize = 0;
        int index = 0;
        for (OrderByColumnSpec column : this.columns) {
            columnBytes[index] = column.getCacheKey();
            columnsBytesSize += columnBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + columnsBytesSize + 4).put((byte)1);
        for (byte[] columnByte : columnBytes) {
            buffer.put(columnByte);
        }
        buffer.put(Ints.toByteArray((int)this.limit));
        return buffer.array();
    }

    private static class TopNFunction
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;
        private final int limit;

        public TopNFunction(Ordering<Row> ordering, int limit) {
            this.ordering = ordering;
            this.limit = limit;
        }

        public Sequence<Row> apply(Sequence<Row> input) {
            return new TopNSequence<Row>(input, this.ordering, this.limit);
        }
    }

    private static class SortingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private final Ordering<Row> ordering;

        public SortingFn(Ordering<Row> ordering) {
            this.ordering = ordering;
        }

        public Sequence<Row> apply(@Nullable Sequence<Row> input) {
            return Sequences.sort(input, this.ordering);
        }
    }

    private static class LimitingFn
    implements Function<Sequence<Row>, Sequence<Row>> {
        private int limit;

        public LimitingFn(int limit) {
            this.limit = limit;
        }

        public Sequence<Row> apply(Sequence<Row> input) {
            return Sequences.limit(input, (int)this.limit);
        }
    }
}

