/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.druid.data.input.Row;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.IdentityExtractionFn;
import io.druid.query.groupby.having.BaseHavingSpec;
import java.util.List;
import java.util.Objects;

public class DimensionSelectorHavingSpec
extends BaseHavingSpec {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public DimensionSelectorHavingSpec(@JsonProperty(value="dimension") String dimName, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimName, (Object)"Must have attribute 'dimension'");
        this.value = value;
        this.extractionFn = extractionFn != null ? extractionFn : IdentityExtractionFn.getInstance();
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public boolean eval(Row row) {
        List dimRowValList = row.getDimension(this.dimension);
        if (dimRowValList == null || dimRowValList.isEmpty()) {
            return Strings.isNullOrEmpty((String)this.value);
        }
        for (String rowVal : dimRowValList) {
            String extracted = this.getExtractionFn().apply(rowVal);
            if (this.value != null && this.value.equals(extracted)) {
                return true;
            }
            if (extracted != null && !extracted.isEmpty()) continue;
            return Strings.isNullOrEmpty((String)this.value);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSelectorHavingSpec that = (DimensionSelectorHavingSpec)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.value, that.value) && Objects.equals(this.extractionFn, that.extractionFn);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.value, this.extractionFn);
    }

    public String toString() {
        return "DimensionSelectorHavingSpec{dimension='" + this.dimension + '\'' + ", value='" + this.value + '\'' + ", extractionFn=" + this.extractionFn + '}';
    }
}

