/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae.column;

import io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import io.druid.segment.ColumnValueSelector;
import java.nio.ByteBuffer;
import java.util.Map;

public class FloatGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap) {
        float val = key.getFloat(selectorPlus.getKeyBufferPosition());
        resultMap.put(selectorPlus.getOutputName(), Float.valueOf(val));
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        valuess[columnIndex] = Float.valueOf(selector.getFloat());
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        return Float.valueOf(selector.getFloat());
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putFloat(keyBufferPosition, ((Float)obj).floatValue());
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        keyBuffer.putFloat(keyBufferPosition, ((Float)rowObj).floatValue());
        stack[columnIndex] = 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }
}

