/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae.column;

import io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import io.druid.segment.ColumnValueSelector;
import java.nio.ByteBuffer;
import java.util.Map;

public class DoubleGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 8;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap) {
        double val = key.getDouble(selectorPlus.getKeyBufferPosition());
        resultMap.put(selectorPlus.getOutputName(), val);
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] values) {
        values[columnIndex] = selector.getDouble();
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        return selector.getDouble();
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putDouble(keyBufferPosition, (Double)obj);
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        keyBuffer.putDouble(keyBufferPosition, (Double)rowObj);
        stack[columnIndex] = 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }
}

