/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import io.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.IndexedInts;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class DictionaryBuildingStringGroupByColumnSelectorStrategy
extends StringGroupByColumnSelectorStrategy {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private int nextId = 0;
    private final List<String> dictionary = Lists.newArrayList();
    private final Object2IntOpenHashMap<String> reverseDictionary = new Object2IntOpenHashMap();

    public DictionaryBuildingStringGroupByColumnSelectorStrategy() {
        this.reverseDictionary.defaultReturnValue(-1);
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap) {
        int id = key.getInt(selectorPlus.getKeyBufferPosition());
        if (id != -1) {
            String value = this.dictionary.get(id);
            resultMap.put(selectorPlus.getOutputName(), value);
        } else {
            resultMap.put(selectorPlus.getOutputName(), "");
        }
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        int[] newIds = new int[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            String value = dimSelector.lookupName(row.get(i));
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId < 0) {
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, this.nextId);
                newIds[i] = this.nextId++;
                continue;
            }
            newIds[i] = dictId;
        }
        valuess[columnIndex] = ArrayBasedIndexedInts.of(newIds);
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
        if (row.size() == 0) {
            return -1;
        }
        String value = dimSelector.lookupName(row.get(0));
        int dictId = this.reverseDictionary.getInt((Object)value);
        if (dictId < 0) {
            this.dictionary.add(value);
            this.reverseDictionary.put((Object)value, this.nextId);
            return this.nextId++;
        }
        return dictId;
    }
}

