/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.java.util.common.parsers.CloseableIterator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.groupby.epinephelinae.AggregateResult;
import io.druid.query.groupby.epinephelinae.Groupers;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;

public interface Grouper<KeyType>
extends Closeable {
    public void init();

    public boolean isInitialized();

    public AggregateResult aggregate(KeyType var1, int var2);

    default public AggregateResult aggregate(KeyType key) {
        Preconditions.checkNotNull(key, (Object)"key");
        return this.aggregate(key, this.hashFunction().applyAsInt(key));
    }

    public void reset();

    default public ToIntFunction<KeyType> hashFunction() {
        return Groupers::hash;
    }

    @Override
    public void close();

    public CloseableIterator<Entry<KeyType>> iterator(boolean var1);

    public static interface BufferComparator {
        public int compare(ByteBuffer var1, ByteBuffer var2, int var3, int var4);
    }

    public static interface KeySerde<T> {
        public int keySize();

        public Class<T> keyClazz();

        public List<String> getDictionary();

        public ByteBuffer toByteBuffer(T var1);

        public T fromByteBuffer(ByteBuffer var1, int var2);

        public BufferComparator bufferComparator();

        public BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] var1, int[] var2);

        public void reset();
    }

    public static interface KeySerdeFactory<T> {
        public long getMaxDictionarySize();

        public KeySerde<T> factorize();

        public KeySerde<T> factorizeWithDictionary(List<String> var1);

        public Comparator<Entry<T>> objectComparator(boolean var1);
    }

    public static class Entry<T> {
        final T key;
        final Object[] values;

        @JsonCreator
        public Entry(@JsonProperty(value="k") T key, @JsonProperty(value="v") Object[] values) {
            this.key = key;
            this.values = values;
        }

        @JsonProperty(value="k")
        public T getKey() {
            return this.key;
        }

        @JsonProperty(value="v")
        public Object[] getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.key.equals(entry.key)) {
                return false;
            }
            return Arrays.equals(this.values, entry.values);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String toString() {
            return "Entry{key=" + this.key + ", values=" + Arrays.toString(this.values) + '}';
        }
    }
}

