/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.druid.collections.ResourceHolder;
import io.druid.common.guava.SettableSupplier;
import io.druid.data.input.Row;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.guava.FilteredSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.RowBasedColumnSelectorFactory;
import io.druid.query.groupby.epinephelinae.AggregateResult;
import io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import io.druid.query.groupby.resource.GroupByQueryResource;
import io.druid.segment.column.ValueType;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.filter.Filters;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByRowProcessor {
    public static Sequence<Row> process(Query queryParam, Sequence<Row> rows, final Map<String, ValueType> rowSignature, GroupByQueryConfig config, final GroupByQueryResource resource, final ObjectMapper spillMapper, String processingTmpDir, final int mergeBufferSize) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        final GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        final AggregatorFactory[] aggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            aggregatorFactories[i] = query.getAggregatorSpecs().get(i);
        }
        final File temporaryStorageDirectory = new File(processingTmpDir, StringUtils.format((String)"druid-groupBy-%s_%s", (Object[])new Object[]{UUID.randomUUID(), query.getId()}));
        final List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        final SettableSupplier rowSupplier = new SettableSupplier();
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create((Supplier<? extends Row>)rowSupplier, rowSignature);
        final ValueMatcher filterMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(columnSelectorFactory);
        final FilteredSequence filteredSequence = new FilteredSequence(rows, (Predicate)new Predicate<Row>(){

            public boolean apply(Row input) {
                boolean inInterval = false;
                DateTime rowTime = input.getTimestamp();
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains((ReadableInstant)rowTime)) continue;
                    inInterval = true;
                    break;
                }
                if (!inInterval) {
                    return false;
                }
                rowSupplier.set((Object)input);
                return filterMatcher.matches();
            }
        });
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                final ArrayList closeOnExit = Lists.newArrayList();
                try {
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    closeOnExit.add(temporaryStorage);
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, true, rowSignature, querySpecificConfig, new Supplier<ByteBuffer>(){

                        public ByteBuffer get() {
                            ResourceHolder<ByteBuffer> mergeBufferHolder = resource.getMergeBuffer();
                            closeOnExit.add(mergeBufferHolder);
                            return (ByteBuffer)mergeBufferHolder.get();
                        }
                    }, temporaryStorage, spillMapper, aggregatorFactories, mergeBufferSize);
                    Grouper grouper = (Grouper)pair.lhs;
                    Accumulator accumulator = (Accumulator)pair.rhs;
                    closeOnExit.add(grouper);
                    AggregateResult retVal = (AggregateResult)filteredSequence.accumulate((Object)AggregateResult.ok(), accumulator);
                    if (!retVal.isOk()) {
                        throw new ResourceLimitExceededException(retVal.getReason(), new Object[0]);
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            for (Closeable closeable : Lists.reverse((List)closeOnExit)) {
                                CloseQuietly.close((Closeable)closeable);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse((List)closeOnExit)) {
                        CloseQuietly.close((Closeable)closeable);
                    }
                    throw e;
                }
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }
}

