/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.collections.BlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.ReferenceCountingResourceHolder;
import io.druid.collections.ResourceHolder;
import io.druid.data.input.Row;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.QueryContexts;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.epinephelinae.AggregateResult;
import io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import io.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GroupByMergingQueryRunnerV2
implements QueryRunner<Row> {
    private static final Logger log = new Logger(GroupByMergingQueryRunnerV2.class);
    private static final String CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION = "mergeRunnersUsingChainedExecution";
    private final GroupByQueryConfig config;
    private final Iterable<QueryRunner<Row>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;
    private final int concurrencyHint;
    private final NonBlockingPool<ByteBuffer> processingBufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final String processingTmpDir;
    private final int mergeBufferSize;

    public GroupByMergingQueryRunnerV2(GroupByQueryConfig config, ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<Row>> queryables, int concurrencyHint, NonBlockingPool<ByteBuffer> processingBufferPool, BlockingPool<ByteBuffer> mergeBufferPool, int mergeBufferSize, ObjectMapper spillMapper, String processingTmpDir) {
        this.config = config;
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.concurrencyHint = concurrencyHint;
        this.processingBufferPool = processingBufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.processingTmpDir = processingTmpDir;
        this.mergeBufferSize = mergeBufferSize;
    }

    @Override
    public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
        final GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
        final GroupByQueryConfig querySpecificConfig = this.config.withOverrides(query);
        boolean forceChainedExecution = query.getContextBoolean(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, false);
        QueryPlus queryPlusForRunners = queryPlus.withQuery(query.withOverriddenContext((Map)ImmutableMap.of((Object)CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, (Object)true))).withoutThreadUnsafeState();
        if (QueryContexts.isBySegment(query) || forceChainedExecution) {
            ChainedExecutionQueryRunner runner = new ChainedExecutionQueryRunner((ExecutorService)this.exec, this.queryWatcher, this.queryables);
            return runner.run(queryPlusForRunners, responseContext);
        }
        boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        AggregatorFactory[] combiningAggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            combiningAggregatorFactories[i] = query.getAggregatorSpecs().get(i).getCombiningFactory();
        }
        final File temporaryStorageDirectory = new File(this.processingTmpDir, StringUtils.format((String)"druid-groupBy-%s_%s", (Object[])new Object[]{UUID.randomUUID(), query.getId()}));
        int priority = QueryContexts.getPriority(query);
        long queryTimeout = QueryContexts.getTimeout(query);
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = System.currentTimeMillis() + queryTimeout;
        Supplier<ResourceHolder<ByteBuffer>> combineBufferSupplier = new Supplier<ResourceHolder<ByteBuffer>>(){
            private boolean initialized;
            private ResourceHolder<ByteBuffer> buffer;

            public ResourceHolder<ByteBuffer> get() {
                if (!this.initialized) {
                    this.buffer = GroupByMergingQueryRunnerV2.this.processingBufferPool.take();
                    this.initialized = true;
                }
                return this.buffer;
            }
        };
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>((Supplier)combineBufferSupplier, combiningAggregatorFactories, priority, queryPlusForRunners, responseContext, isSingleThreaded){
            final /* synthetic */ Supplier val$combineBufferSupplier;
            final /* synthetic */ AggregatorFactory[] val$combiningAggregatorFactories;
            final /* synthetic */ int val$priority;
            final /* synthetic */ QueryPlus val$queryPlusForRunners;
            final /* synthetic */ Map val$responseContext;
            final /* synthetic */ boolean val$isSingleThreaded;
            {
                this.val$combineBufferSupplier = supplier;
                this.val$combiningAggregatorFactories = aggregatorFactoryArray;
                this.val$priority = n;
                this.val$queryPlusForRunners = queryPlus;
                this.val$responseContext = map;
                this.val$isSingleThreaded = bl2;
            }

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                final ArrayList resources = Lists.newArrayList();
                try {
                    ReferenceCountingResourceHolder mergeBufferHolder;
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    ReferenceCountingResourceHolder temporaryStorageHolder = ReferenceCountingResourceHolder.fromCloseable((Closeable)temporaryStorage);
                    resources.add(temporaryStorageHolder);
                    try {
                        if (hasTimeout) {
                            long timeout = timeoutAt - System.currentTimeMillis();
                            if (timeout <= 0L || (mergeBufferHolder = GroupByMergingQueryRunnerV2.this.mergeBufferPool.take(timeout)) == null) {
                                throw new TimeoutException();
                            }
                        } else {
                            mergeBufferHolder = GroupByMergingQueryRunnerV2.this.mergeBufferPool.take();
                        }
                        resources.add(mergeBufferHolder);
                    }
                    catch (Exception e) {
                        throw new QueryInterruptedException(e);
                    }
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, false, null, GroupByMergingQueryRunnerV2.this.config, (Supplier<ByteBuffer>)Suppliers.ofInstance((Object)mergeBufferHolder.get()), (Supplier<ResourceHolder<ByteBuffer>>)this.val$combineBufferSupplier, GroupByMergingQueryRunnerV2.this.concurrencyHint, temporaryStorage, GroupByMergingQueryRunnerV2.this.spillMapper, this.val$combiningAggregatorFactories, GroupByMergingQueryRunnerV2.this.exec, this.val$priority, hasTimeout, timeoutAt, GroupByMergingQueryRunnerV2.this.mergeBufferSize);
                    Grouper grouper = (Grouper)pair.lhs;
                    final Accumulator accumulator = (Accumulator)pair.rhs;
                    grouper.init();
                    final ReferenceCountingResourceHolder grouperHolder = ReferenceCountingResourceHolder.fromCloseable((Closeable)grouper);
                    resources.add(grouperHolder);
                    ListenableFuture futures = Futures.allAsList((Iterable)Lists.newArrayList((Iterable)Iterables.transform((Iterable)GroupByMergingQueryRunnerV2.this.queryables, (Function)new Function<QueryRunner<Row>, ListenableFuture<AggregateResult>>(){

                        public ListenableFuture<AggregateResult> apply(final QueryRunner<Row> input) {
                            if (input == null) {
                                throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                            }
                            ListenableFuture future = GroupByMergingQueryRunnerV2.this.exec.submit((Callable)new AbstractPrioritizedCallable<AggregateResult>(val$priority){

                                /*
                                 * Exception decompiling
                                 */
                                @Override
                                public AggregateResult call() throws Exception {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }
                            });
                            if (val$isSingleThreaded) {
                                GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, (ListenableFuture<List<AggregateResult>>)Futures.allAsList((Iterable)ImmutableList.of((Object)future)), hasTimeout, timeoutAt - System.currentTimeMillis());
                            }
                            return future;
                        }
                    })));
                    if (!this.val$isSingleThreaded) {
                        GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, (ListenableFuture<List<AggregateResult>>)futures, hasTimeout, timeoutAt - System.currentTimeMillis());
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, new Closeable(){

                        @Override
                        public void close() throws IOException {
                            for (Closeable closeable : Lists.reverse((List)resources)) {
                                CloseQuietly.close((Closeable)closeable);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    for (Closeable closeable : Lists.reverse((List)resources)) {
                        CloseQuietly.close((Closeable)closeable);
                    }
                    throw e;
                }
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private void waitForFutureCompletion(GroupByQuery query, ListenableFuture<List<AggregateResult>> future, boolean hasTimeout, long timeout) {
        try {
            if (this.queryWatcher != null) {
                this.queryWatcher.registerQuery(query, future);
            }
            if (hasTimeout && timeout <= 0L) {
                throw new TimeoutException();
            }
            List results = hasTimeout ? (List)future.get(timeout, TimeUnit.MILLISECONDS) : (List)future.get();
            for (AggregateResult result : results) {
                if (result.isOk()) continue;
                future.cancel(true);
                throw new ResourceLimitExceededException(result.getReason(), new Object[0]);
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    static /* synthetic */ Logger access$800() {
        return log;
    }
}

