/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import io.druid.java.util.common.io.Closer;
import io.druid.java.util.common.parsers.CloseableIterator;
import io.druid.query.groupby.epinephelinae.Grouper;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;

public class CloseableGrouperIterator<KeyType, T>
implements CloseableIterator<T> {
    private final Function<Grouper.Entry<KeyType>, T> transformer;
    private final CloseableIterator<Grouper.Entry<KeyType>> iterator;
    private final Closer closer;

    public CloseableGrouperIterator(Grouper<KeyType> grouper, boolean sorted, Function<Grouper.Entry<KeyType>, T> transformer, Closeable closeable) {
        this.transformer = transformer;
        this.iterator = grouper.iterator(sorted);
        this.closer = Closer.create();
        this.closer.register(this.iterator);
        this.closer.register(closeable);
    }

    public T next() {
        return this.transformer.apply((Grouper.Entry<KeyType>)this.iterator.next());
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

