/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.query.groupby.epinephelinae.Groupers;
import java.nio.ByteBuffer;

public class ByteBufferHashTable {
    protected final int maxSizeForTesting;
    protected static final int HASH_SIZE = 4;
    protected final float maxLoadFactor;
    protected final int initialBuckets;
    protected final ByteBuffer buffer;
    protected final int bucketSizeWithHash;
    protected final int tableArenaSize;
    protected final int keySize;
    protected int tableStart;
    protected ByteBuffer tableBuffer;
    protected int size;
    protected int regrowthThreshold;
    protected int maxBuckets;
    protected int growthCount;
    protected BucketUpdateHandler bucketUpdateHandler;

    public static int calculateTableArenaSizeWithPerBucketAdditionalSize(int bufferCapacity, int bucketSize, int perBucketAdditionalSize) {
        return bufferCapacity / (bucketSize + perBucketAdditionalSize) * bucketSize;
    }

    public static int calculateTableArenaSizeWithFixedAdditionalSize(int bufferCapacity, int bucketSize, int fixedAdditionalSize) {
        return (bufferCapacity - fixedAdditionalSize) / bucketSize * bucketSize;
    }

    public ByteBufferHashTable(float maxLoadFactor, int initialBuckets, int bucketSizeWithHash, ByteBuffer buffer, int keySize, int maxSizeForTesting, BucketUpdateHandler bucketUpdateHandler) {
        this.maxLoadFactor = maxLoadFactor;
        this.initialBuckets = initialBuckets;
        this.bucketSizeWithHash = bucketSizeWithHash;
        this.buffer = buffer;
        this.keySize = keySize;
        this.maxSizeForTesting = maxSizeForTesting;
        this.tableArenaSize = buffer.capacity();
        this.bucketUpdateHandler = bucketUpdateHandler;
    }

    public void reset() {
        int nextTableStart;
        long nextBucketsSize;
        this.size = 0;
        this.maxBuckets = Math.min(this.tableArenaSize / this.bucketSizeWithHash, this.initialBuckets);
        this.regrowthThreshold = this.maxSizeForBuckets(this.maxBuckets);
        if (this.maxBuckets < 1) {
            throw new IAE("Not enough capacity for even one row! Need[%,d] but have[%,d].", new Object[]{this.bucketSizeWithHash + 4, this.buffer.capacity()});
        }
        this.tableStart = this.tableArenaSize - this.maxBuckets * this.bucketSizeWithHash;
        int nextBuckets = this.maxBuckets * 2;
        while ((nextBucketsSize = (long)nextBuckets * (long)this.bucketSizeWithHash) <= Integer.MAX_VALUE && (nextTableStart = this.tableStart - nextBuckets * this.bucketSizeWithHash) > this.tableArenaSize / 2) {
            this.tableStart = nextTableStart;
            nextBuckets *= 2;
        }
        if (this.tableStart < this.tableArenaSize / 2) {
            this.tableStart = 0;
        }
        ByteBuffer bufferDup = this.buffer.duplicate();
        bufferDup.position(this.tableStart);
        bufferDup.limit(this.tableStart + this.maxBuckets * this.bucketSizeWithHash);
        this.tableBuffer = bufferDup.slice();
        for (int i = 0; i < this.maxBuckets; ++i) {
            this.tableBuffer.put(i * this.bucketSizeWithHash, (byte)0);
        }
    }

    public void adjustTableWhenFull() {
        int newMaxSize;
        int newBuckets;
        int newTableStart;
        if (this.tableStart == 0) {
            return;
        }
        if ((long)this.maxBuckets * 3L * (long)this.bucketSizeWithHash > (long)this.tableArenaSize - (long)this.tableStart) {
            newTableStart = 0;
            newBuckets = this.tableStart / this.bucketSizeWithHash;
            newMaxSize = this.maxSizeForBuckets(newBuckets);
        } else {
            newTableStart = this.tableStart + this.tableBuffer.limit();
            newBuckets = this.maxBuckets * 2;
            newMaxSize = this.maxSizeForBuckets(newBuckets);
        }
        if (newBuckets < this.maxBuckets) {
            throw new ISE("WTF?! newBuckets[%,d] < maxBuckets[%,d]", new Object[]{newBuckets, this.maxBuckets});
        }
        ByteBuffer newTableBuffer = this.buffer.duplicate();
        newTableBuffer.position(newTableStart);
        newTableBuffer.limit(newTableStart + newBuckets * this.bucketSizeWithHash);
        newTableBuffer = newTableBuffer.slice();
        int newSize = 0;
        for (int i = 0; i < newBuckets; ++i) {
            newTableBuffer.put(i * this.bucketSizeWithHash, (byte)0);
        }
        ByteBuffer entryBuffer = this.tableBuffer.duplicate();
        ByteBuffer keyBuffer = this.tableBuffer.duplicate();
        int oldBuckets = this.maxBuckets;
        if (this.bucketUpdateHandler != null) {
            this.bucketUpdateHandler.handlePreTableSwap();
        }
        for (int oldBucket = 0; oldBucket < oldBuckets; ++oldBucket) {
            if (!this.isBucketUsed(oldBucket)) continue;
            int oldBucketOffset = oldBucket * this.bucketSizeWithHash;
            entryBuffer.limit((oldBucket + 1) * this.bucketSizeWithHash);
            entryBuffer.position(oldBucketOffset);
            keyBuffer.limit(entryBuffer.position() + 4 + this.keySize);
            keyBuffer.position(entryBuffer.position() + 4);
            int keyHash = entryBuffer.getInt(entryBuffer.position()) & Integer.MAX_VALUE;
            int newBucket = this.findBucket(true, newBuckets, newTableBuffer, keyBuffer, keyHash);
            if (newBucket < 0) {
                throw new ISE("WTF?! Couldn't find a bucket while resizing?!", new Object[0]);
            }
            int newBucketOffset = newBucket * this.bucketSizeWithHash;
            newTableBuffer.position(newBucketOffset);
            newTableBuffer.put(entryBuffer);
            ++newSize;
            if (this.bucketUpdateHandler == null) continue;
            this.bucketUpdateHandler.handleBucketMove(oldBucketOffset, newBucketOffset, this.tableBuffer, newTableBuffer);
        }
        this.maxBuckets = newBuckets;
        this.regrowthThreshold = newMaxSize;
        this.tableBuffer = newTableBuffer;
        this.tableStart = newTableStart;
        ++this.growthCount;
        if (this.size != newSize) {
            throw new ISE("WTF?! size[%,d] != newSize[%,d] after resizing?!", new Object[]{this.size, newSize});
        }
    }

    protected void initializeNewBucketKey(int bucket, ByteBuffer keyBuffer, int keyHash) {
        int offset = bucket * this.bucketSizeWithHash;
        this.tableBuffer.position(offset);
        this.tableBuffer.putInt(Groupers.getUsedFlag(keyHash));
        this.tableBuffer.put(keyBuffer);
        ++this.size;
        if (this.bucketUpdateHandler != null) {
            this.bucketUpdateHandler.handleNewBucket(offset);
        }
    }

    protected int findBucketWithAutoGrowth(ByteBuffer keyBuffer, int keyHash) {
        int bucket = this.findBucket(this.canAllowNewBucket(), this.maxBuckets, this.tableBuffer, keyBuffer, keyHash);
        if (bucket < 0 && this.size < this.maxSizeForTesting) {
            this.adjustTableWhenFull();
            bucket = this.findBucket(this.size < this.regrowthThreshold, this.maxBuckets, this.tableBuffer, keyBuffer, keyHash);
        }
        return bucket;
    }

    protected int findBucket(boolean allowNewBucket, int buckets, ByteBuffer targetTableBuffer, ByteBuffer keyBuffer, int keyHash) {
        int startBucket;
        int bucket = startBucket = keyHash % buckets;
        block0: while (true) {
            int bucketOffset;
            if ((targetTableBuffer.get(bucketOffset = bucket * this.bucketSizeWithHash) & 0x80) == 0) {
                return allowNewBucket ? bucket : -1;
            }
            int i = bucketOffset + 4;
            for (int j = keyBuffer.position(); j < keyBuffer.position() + this.keySize; ++j) {
                if (targetTableBuffer.get(i) != keyBuffer.get(j)) {
                    if (++bucket == buckets) {
                        bucket = 0;
                    }
                    if (bucket != startBucket) continue block0;
                    return -1;
                }
                ++i;
            }
            break;
        }
        return bucket;
    }

    protected boolean canAllowNewBucket() {
        return this.size < Math.min(this.regrowthThreshold, this.maxSizeForTesting);
    }

    protected int getOffsetForBucket(int bucket) {
        return bucket * this.bucketSizeWithHash;
    }

    protected int maxSizeForBuckets(int buckets) {
        return Math.max(1, (int)((float)buckets * this.maxLoadFactor));
    }

    protected boolean isBucketUsed(int bucket) {
        return (this.tableBuffer.get(bucket * this.bucketSizeWithHash) & 0x80) == 128;
    }

    protected boolean isOffsetUsed(int bucketOffset) {
        return (this.tableBuffer.get(bucketOffset) & 0x80) == 128;
    }

    public ByteBuffer getTableBuffer() {
        return this.tableBuffer;
    }

    public int getSize() {
        return this.size;
    }

    public int getRegrowthThreshold() {
        return this.regrowthThreshold;
    }

    public int getMaxBuckets() {
        return this.maxBuckets;
    }

    public int getGrowthCount() {
        return this.growthCount;
    }

    public static interface BucketUpdateHandler {
        public void handleNewBucket(int var1);

        public void handlePreTableSwap();

        public void handleBucketMove(int var1, int var2, ByteBuffer var3, ByteBuffer var4);
    }
}

