/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.Row;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IdLookup;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.RangeIndexedInts;
import io.druid.segment.data.ZeroIndexedInts;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class RowBasedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final Supplier<? extends Row> row;
    private final Map<String, ValueType> rowSignature;

    private RowBasedColumnSelectorFactory(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        this.row = row;
        this.rowSignature = rowSignature != null ? rowSignature : ImmutableMap.of();
    }

    public static RowBasedColumnSelectorFactory create(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory(row, rowSignature);
    }

    public static RowBasedColumnSelectorFactory create(final ThreadLocal<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory((Supplier<? extends Row>)new Supplier<Row>(){

            public Row get() {
                return (Row)row.get();
            }
        }, rowSignature);
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        final String dimension = dimensionSpec.getDimension();
        final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if ("__time".equals(dimensionSpec.getDimension())) {
            if (extractionFn == null) {
                throw new UnsupportedOperationException("time dimension must provide an extraction function");
            }
            return new DimensionSelector(){

                @Override
                public IndexedInts getRow() {
                    return ZeroIndexedInts.instance();
                }

                @Override
                public ValueMatcher makeValueMatcher(final String value) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String rowValue = extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                            return Objects.equals(rowValue, value);
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("extractionFn", extractionFn);
                        }
                    };
                }

                @Override
                public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String rowValue = extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                            return predicate.apply((Object)rowValue);
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("extractionFn", extractionFn);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }

                @Override
                public int getValueCardinality() {
                    return -1;
                }

                @Override
                public String lookupName(int id) {
                    return extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                }

                @Override
                public boolean nameLookupPossibleInAdvance() {
                    return false;
                }

                @Override
                @Nullable
                public IdLookup idLookup() {
                    return null;
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.lookupName(0);
                }

                @Override
                public Class classOfObject() {
                    return String.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                    inspector.visit("extractionFn", extractionFn);
                }
            };
        }
        return new DimensionSelector(){

            @Override
            public IndexedInts getRow() {
                List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                return RangeIndexedInts.create(dimensionValues != null ? dimensionValues.size() : 0);
            }

            @Override
            public ValueMatcher makeValueMatcher(final String value) {
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return value == null;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!Objects.equals(Strings.emptyToNull((String)dimensionValue), value)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return value == null;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!Objects.equals(extractionFn.apply(Strings.emptyToNull((String)dimensionValue)), value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final boolean matchNull = predicate.apply(null);
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return matchNull;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!predicate.apply((Object)Strings.emptyToNull((String)dimensionValue))) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return matchNull;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!predicate.apply((Object)extractionFn.apply(Strings.emptyToNull((String)dimensionValue)))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("predicate", predicate);
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            public String lookupName(int id) {
                String value = Strings.emptyToNull((String)((String)((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension).get(id)));
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            @Nullable
            public Object getObject() {
                List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                if (dimensionValues == null) {
                    return null;
                }
                if (dimensionValues.size() == 1) {
                    return dimensionValues.get(0);
                }
                return dimensionValues.toArray(new String[0]);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                inspector.visit("extractionFn", extractionFn);
            }
        };
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final String columnName) {
        if (columnName.equals("__time")) {
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                }
            }
            return new TimeLongColumnSelector();
        }
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName).doubleValue();
            }

            @Override
            public float getFloat() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName).floatValue();
            }

            @Override
            public long getLong() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName).longValue();
            }

            @Override
            @Nullable
            public Object getObject() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getRaw(columnName);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if ("__time".equals(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ValueType.LONG);
        }
        ValueType valueType = this.rowSignature.get(columnName);
        return valueType != null ? new ColumnCapabilitiesImpl().setType(valueType) : null;
    }
}

