/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.druid.data.input.Row;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.strategy.GroupByStrategySelector;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<Row, GroupByQuery> {
    private final GroupByStrategySelector strategySelector;
    private final GroupByQueryQueryToolChest toolChest;

    @Inject
    public GroupByQueryRunnerFactory(GroupByStrategySelector strategySelector, GroupByQueryQueryToolChest toolChest) {
        this.strategySelector = strategySelector;
        this.toolChest = toolChest;
    }

    @Override
    public QueryRunner<Row> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.strategySelector);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ExecutorService exec, final Iterable<QueryRunner<Row>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                QueryRunner<Row> rowQueryRunner = GroupByQueryRunnerFactory.this.strategySelector.strategize((GroupByQuery)queryPlus.getQuery()).mergeRunners(queryExecutor, queryRunners);
                return rowQueryRunner.run(queryPlus, responseContext);
            }
        };
    }

    @Override
    public QueryToolChest<Row, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<Row> {
        private final StorageAdapter adapter;
        private final GroupByStrategySelector strategySelector;

        public GroupByQueryRunner(Segment segment, GroupByStrategySelector strategySelector) {
            this.adapter = segment.asStorageAdapter();
            this.strategySelector = strategySelector;
        }

        @Override
        public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
            Query<Row> query = queryPlus.getQuery();
            if (!(query instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{query.getClass(), GroupByQuery.class});
            }
            return this.strategySelector.strategize((GroupByQuery)query).process((GroupByQuery)query, this.adapter);
        }
    }
}

