/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.collections.NonBlockingPool;
import io.druid.common.guava.GuavaUtils;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.StringDimensionSchema;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.joda.time.DateTime;

public class GroupByQueryHelper {
    public static final String CTX_KEY_SORT_RESULTS = "sortResults";

    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool, boolean combine) {
        DateTime timeStart;
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        Granularity gran = query.getGranularity();
        DateTime granTimeStart = timeStart = query.getIntervals().get(0).getStart();
        if (!Granularities.ALL.equals(gran)) {
            granTimeStart = gran.bucketStart(timeStart);
        }
        List aggs = combine ? Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        }) : query.getAggregatorSpecs();
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        boolean sortResults = query.getContextValue(CTX_KEY_SORT_RESULTS, true);
        ArrayList dimensionSchemas = Lists.newArrayList();
        for (DimensionSpec dimension : query.getDimensions()) {
            dimensionSchemas.add(new StringDimensionSchema(dimension.getOutputName()));
        }
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec((List)dimensionSchemas, null, null)).withMetrics(aggs.toArray(new AggregatorFactory[aggs.size()])).withQueryGranularity(gran).withMinTimestamp(granTimeStart.getMillis()).build();
        IncrementalIndex index = query.getContextValue("useOffheap", false) != false ? new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOffheap(bufferPool) : new IncrementalIndex.Builder().setIndexSchema(indexSchema).setDeserializeComplexMetrics(false).setConcurrentEventAdd(true).setSortFacts(sortResults).setMaxRowCount(querySpecificConfig.getMaxResults()).buildOnheap();
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof MapBasedRow) {
                    try {
                        MapBasedRow row = (MapBasedRow)in;
                        accumulated.add((InputRow)new MapBasedInputRow(row.getTimestamp(), dimensions, row.getEvent()));
                    }
                    catch (IndexSizeExceededException e) {
                        throw new ResourceLimitExceededException(e.getMessage(), new Object[0]);
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", new Object[]{in.getClass()});
                }
                return accumulated;
            }
        };
        return new Pair((Object)index, (Object)accumulator);
    }

    public static <T> Pair<Queue, Accumulator<Queue, T>> createBySegmentAccumulatorPair() {
        ConcurrentLinkedQueue init = new ConcurrentLinkedQueue();
        Accumulator accumulator = new Accumulator<Queue, T>(){

            public Queue accumulate(Queue accumulated, T in) {
                if (in == null) {
                    throw new ISE("Cannot have null result", new Object[0]);
                }
                accumulated.offer(in);
                return accumulated;
            }
        };
        return new Pair(init, (Object)accumulator);
    }

    public static IncrementalIndex makeIncrementalIndex(GroupByQuery query, GroupByQueryConfig config, NonBlockingPool<ByteBuffer> bufferPool, Sequence<Row> rows, boolean combine) {
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config, bufferPool, combine);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    public static Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs(), query.isDescending())), (Function)new Function<Row, Row>(){

            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }

    public static Map<String, ValueType> rowSignatureFor(GroupByQuery query) {
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            types.put((Object)dimensionSpec.getOutputName(), (Object)dimensionSpec.getOutputType());
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            String typeName = aggregatorFactory.getTypeName();
            ValueType valueType = typeName != null ? (ValueType)GuavaUtils.getEnumIfPresent(ValueType.class, (String)StringUtils.toUpperCase((String)typeName)) : null;
            if (valueType == null) continue;
            types.put((Object)aggregatorFactory.getName(), (Object)valueType);
        }
        return types.build();
    }
}

