/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Json;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.groupby.DefaultGroupByQueryMetrics;
import io.druid.query.groupby.GroupByQueryMetrics;
import io.druid.query.groupby.GroupByQueryMetricsFactory;

@LazySingleton
public class DefaultGroupByQueryMetricsFactory
implements GroupByQueryMetricsFactory {
    private static final GroupByQueryMetricsFactory INSTANCE = new DefaultGroupByQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static GroupByQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultGroupByQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public GroupByQueryMetrics makeMetrics() {
        return new DefaultGroupByQueryMetrics(this.jsonMapper);
    }
}

