/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.query.DefaultQueryMetrics;
import io.druid.query.DruidMetrics;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryMetrics;

public class DefaultGroupByQueryMetrics
extends DefaultQueryMetrics<GroupByQuery>
implements GroupByQueryMetrics {
    public DefaultGroupByQueryMetrics(ObjectMapper jsonMapper) {
        super(jsonMapper);
    }

    @Override
    public void query(GroupByQuery query) {
        super.query(query);
        this.numDimensions(query);
        this.numMetrics(query);
        this.numComplexMetrics(query);
        this.granularity(query);
    }

    @Override
    public void numDimensions(GroupByQuery query) {
        this.setDimension("numDimensions", String.valueOf(query.getDimensions().size()));
    }

    @Override
    public void numMetrics(GroupByQuery query) {
        this.setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size()));
    }

    @Override
    public void numComplexMetrics(GroupByQuery query) {
        int numComplexAggs = DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs());
        this.setDimension("numComplexMetrics", String.valueOf(numComplexAggs));
    }

    @Override
    public void granularity(GroupByQuery query) {
    }
}

