/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.java.util.common.IAE;
import io.druid.query.dimension.ColumnSelectorStrategyFactory;
import io.druid.query.filter.DoubleValueMatcherColumnSelectorStrategy;
import io.druid.query.filter.FloatValueMatcherColumnSelectorStrategy;
import io.druid.query.filter.LongValueMatcherColumnSelectorStrategy;
import io.druid.query.filter.StringValueMatcherColumnSelectorStrategy;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ValueType;

public class ValueMatcherColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<ValueMatcherColumnSelectorStrategy> {
    private static final ValueMatcherColumnSelectorStrategyFactory INSTANCE = new ValueMatcherColumnSelectorStrategyFactory();

    private ValueMatcherColumnSelectorStrategyFactory() {
    }

    public static ValueMatcherColumnSelectorStrategyFactory instance() {
        return INSTANCE;
    }

    @Override
    public ValueMatcherColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType type = capabilities.getType();
        switch (type) {
            case STRING: {
                return new StringValueMatcherColumnSelectorStrategy();
            }
            case LONG: {
                return new LongValueMatcherColumnSelectorStrategy();
            }
            case FLOAT: {
                return new FloatValueMatcherColumnSelectorStrategy();
            }
            case DOUBLE: {
                return new DoubleValueMatcherColumnSelectorStrategy();
            }
        }
        throw new IAE("Cannot create column selector strategy from invalid type [%s]", new Object[]{type});
    }
}

