/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.ValueGetter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.BooleanValueMatcher;

public class StringValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<DimensionSelector> {
    private static final String[] NULL_VALUE = new String[]{null};
    private static final ValueGetter NULL_VALUE_GETTER = new ValueGetter(){

        @Override
        public String[] get() {
            return NULL_VALUE;
        }
    };

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, String value) {
        value = Strings.emptyToNull((String)value);
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(value == null);
        }
        return selector.makeValueMatcher(value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        if (selector.getValueCardinality() == 0) {
            return BooleanValueMatcher.of(predicate.apply(null));
        }
        return selector.makeValueMatcher(predicate);
    }

    @Override
    public ValueGetter makeValueGetter(final DimensionSelector selector) {
        if (selector.getValueCardinality() == 0) {
            return NULL_VALUE_GETTER;
        }
        return new ValueGetter(){

            @Override
            public String[] get() {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return NULL_VALUE;
                }
                String[] values = new String[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = Strings.emptyToNull((String)selector.lookupName(row.get(i)));
                }
                return values;
            }
        };
    }
}

