/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import io.druid.common.guava.GuavaUtils;
import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.InDimFilter;
import io.druid.segment.filter.DimensionPredicateFilter;
import io.druid.segment.filter.SelectorFilter;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;

public class SelectorDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;
    private final Object initLock = new Object();
    private DruidLongPredicate longPredicate;
    private DruidFloatPredicate floatPredicate;
    private DruidDoublePredicate druidDoublePredicate;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        this.dimension = dimension;
        this.value = Strings.nullToEmpty((String)value);
        this.extractionFn = extractionFn;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valueBytes = this.value == null ? new byte[]{} : StringUtils.toUtf8((String)this.value);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + valueBytes.length + extractionFnBytes.length).put((byte)0).put(dimensionBytes).put((byte)-1).put(valueBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return new InDimFilter(this.dimension, (Collection<String>)ImmutableList.of((Object)this.value), this.extractionFn).optimize();
    }

    @Override
    public Filter toFilter() {
        if (this.extractionFn == null) {
            return new SelectorFilter(this.dimension, this.value);
        }
        final String valueOrNull = Strings.emptyToNull((String)this.value);
        DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return Predicates.equalTo((Object)valueOrNull);
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                SelectorDimFilter.this.initLongPredicate();
                return SelectorDimFilter.this.longPredicate;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                SelectorDimFilter.this.initFloatPredicate();
                return SelectorDimFilter.this.floatPredicate;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                SelectorDimFilter.this.initDoublePredicate();
                return SelectorDimFilter.this.druidDoublePredicate;
            }
        };
        return new DimensionPredicateFilter(this.dimension, predicateFactory, this.extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format((String)"%s(%s) = %s", (Object[])new Object[]{this.extractionFn, this.dimension, this.value});
        }
        return StringUtils.format((String)"%s = %s", (Object[])new Object[]{this.dimension, this.value});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        retSet.add(Range.singleton((Comparable)((Object)Strings.nullToEmpty((String)this.value))));
        return retSet;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLongPredicate() {
        if (this.longPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.longPredicate != null) {
                return;
            }
            Long valueAsLong = GuavaUtils.tryParseLong((String)this.value);
            if (valueAsLong == null) {
                this.longPredicate = DruidLongPredicate.ALWAYS_FALSE;
            } else {
                long unboxedLong = valueAsLong;
                this.longPredicate = input -> input == unboxedLong;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFloatPredicate() {
        if (this.floatPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.floatPredicate != null) {
                return;
            }
            Float valueAsFloat = Floats.tryParse((String)this.value);
            if (valueAsFloat == null) {
                this.floatPredicate = DruidFloatPredicate.ALWAYS_FALSE;
            } else {
                int floatBits = Float.floatToIntBits(valueAsFloat.floatValue());
                this.floatPredicate = input -> Float.floatToIntBits(input) == floatBits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDoublePredicate() {
        if (this.druidDoublePredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.druidDoublePredicate != null) {
                return;
            }
            Double aDouble = Doubles.tryParse((String)this.value);
            if (aDouble == null) {
                this.druidDoublePredicate = DruidDoublePredicate.ALWAYS_FALSE;
            } else {
                long bits = Double.doubleToLongBits(aDouble);
                this.druidDoublePredicate = input -> Double.doubleToLongBits(input) == bits;
            }
        }
    }
}

